/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.generators.LoremGenerator;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.Pair;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LoremNode
extends ZenCodingNode {
    private final int myWordsCount;
    private final LoremGenerator myLoremGenerator = new LoremGenerator();

    public LoremNode(int wordsCount) {
        this.myWordsCount = wordsCount;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        TemplateToken templateToken = new TemplateToken("", Collections.<Pair<String, String>>emptyList());
        TemplateImpl template = new TemplateImpl("", this.myLoremGenerator.generate(this.myWordsCount, numberInIteration <= 0), "");
        templateToken.setTemplate(template, callback);
        GenerationNode node = new GenerationNode(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent);
        List<GenerationNode> list = Collections.singletonList(node);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/LoremNode", "expand"));
        }
        return list;
    }

    public String toString() {
        return "Lorem(" + this.myWordsCount + ")";
    }
}

