/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerationNode
extends UserDataHolderBase {
    private final TemplateToken myTemplateToken;
    private final List<GenerationNode> myChildren = Lists.newArrayList();
    private final int myNumberInIteration;
    private final int myTotalIterations;
    private String mySurroundedText;
    private final boolean myInsertSurroundedTextAtTheEnd;
    private final boolean myInsertNewLineBetweenNodes;
    private GenerationNode myParent;
    private boolean myContainsSurroundedTextMarker = false;

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        this(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent, false);
    }

    public GenerationNode(TemplateToken templateToken, int numberInIteration, int totalIterations, String surroundedText, boolean insertSurroundedTextAtTheEnd, GenerationNode parent, boolean insertNewLineBetweenNodes) {
        this.myTemplateToken = templateToken;
        this.myNumberInIteration = numberInIteration;
        this.myTotalIterations = totalIterations;
        this.mySurroundedText = surroundedText;
        this.myInsertSurroundedTextAtTheEnd = insertSurroundedTextAtTheEnd;
        this.myInsertNewLineBetweenNodes = insertNewLineBetweenNodes;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isInsertNewLineBetweenNodes() {
        return this.myInsertNewLineBetweenNodes;
    }

    public List<GenerationNode> getChildren() {
        return this.myChildren;
    }

    public void addChild(GenerationNode child) {
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void addChildren(Collection<GenerationNode> children) {
        for (GenerationNode child : children) {
            this.addChild(child);
        }
    }

    public boolean isLeaf() {
        return this.myChildren.size() == 0;
    }

    private boolean isBlockTag() {
        XmlTag tag;
        XmlFile xmlFile;
        XmlDocument document;
        if (this.myTemplateToken != null && (document = (xmlFile = this.myTemplateToken.getFile()).getDocument()) != null && (tag = document.getRootTag()) != null) {
            return HtmlUtil.isHtmlBlockTagL(tag.getName());
        }
        return false;
    }

    @NotNull
    public TemplateImpl generate(@NotNull CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator, @NotNull Collection<ZenCodingFilter> filters, boolean insertSurroundedText) {
        Map<String, String> predefinedValues;
        TemplateImpl parentTemplate;
        boolean hasChildren;
        String indentStr;
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
        }
        this.myContainsSurroundedTextMarker = !insertSurroundedText || !this.myInsertSurroundedTextAtTheEnd;
        GenerationNode generationNode = this;
        if (generationNode != this) {
            TemplateImpl templateImpl = generationNode.generate(callback, generator, Collections.<ZenCodingFilter>emptyList(), insertSurroundedText);
            if (templateImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
            }
            return templateImpl;
        }
        boolean shouldNotReformatTemplate = false;
        boolean oneLineTemplateExpanding = false;
        for (ZenCodingFilter filter : filters) {
            generationNode = filter.filterNode(generationNode);
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            shouldNotReformatTemplate = true;
            oneLineTemplateExpanding = true;
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)callback.getProject());
        if (callback.isInInjectedFragment()) {
            Editor editor = callback.getEditor();
            Document document = editor.getDocument();
            if (document instanceof DocumentWindowImpl && ((DocumentWindowImpl)document).isOneLine()) {
                oneLineTemplateExpanding = true;
                filters.add(new SingleLineEmmetFilter());
            }
            indentStr = "";
        } else if (settings.useTabCharacter(callback.getFileType())) {
            indentStr = "\t";
        } else {
            int tabSize = settings.getTabSize(callback.getFileType());
            indentStr = StringUtil.repeatSymbol((char)' ', (int)tabSize);
        }
        LiveTemplateBuilder builder = new LiveTemplateBuilder();
        int end = -1;
        boolean bl = hasChildren = this.myChildren.size() > 0;
        if (this.myTemplateToken instanceof TemplateToken && generator instanceof XmlZenCodingGenerator) {
            TemplateToken xmlTemplateToken = this.myTemplateToken;
            ArrayList<Pair<String, String>> attr2value = new ArrayList<Pair<String, String>>(xmlTemplateToken.getAttribute2Value());
            parentTemplate = this.invokeXmlTemplate(xmlTemplateToken, callback, generator, hasChildren, attr2value);
            predefinedValues = this.buildPredefinedValues(attr2value, (XmlZenCodingGenerator)generator, hasChildren);
        } else {
            parentTemplate = GenerationNode.invokeTemplate(this.myTemplateToken, hasChildren, callback, generator);
            predefinedValues = null;
        }
        String s = parentTemplate.getString();
        for (ZenCodingFilter filter : filters) {
            s = filter.filterText(s, this.myTemplateToken);
        }
        parentTemplate = parentTemplate.copy();
        parentTemplate.setString(s);
        String txt = hasChildren || this.myContainsSurroundedTextMarker ? null : this.mySurroundedText;
        parentTemplate = GenerationNode.expandTemplate(parentTemplate, predefinedValues, txt);
        int offset = builder.insertTemplate(0, parentTemplate, null);
        int newOffset = GenerationNode.gotoChild(callback.getProject(), builder.getText(), offset, 0, builder.length());
        if (offset < builder.length() && newOffset != offset) {
            end = offset;
        }
        offset = newOffset;
        if (end == -1 && offset < builder.length() && this.myChildren.size() == 0) {
            end = offset;
        }
        LiveTemplateBuilder.Marker marker = offset < builder.length() ? builder.createMarker(offset) : null;
        int myChildrenSize = this.myChildren.size();
        for (int i = 0; i < myChildrenSize; ++i) {
            GenerationNode child = this.myChildren.get(i);
            TemplateImpl childTemplate = child.generate(callback, generator, filters, !this.myContainsSurroundedTextMarker);
            boolean blockTag = child.isBlockTag();
            if (!oneLineTemplateExpanding && blockTag && !GenerationNode.isNewLineBefore(builder.getText(), offset)) {
                builder.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            int e = builder.insertTemplate(offset, childTemplate, null);
            int n = offset = marker != null ? marker.getEndOffset() : builder.length();
            if (!oneLineTemplateExpanding && (blockTag && !GenerationNode.isNewLineAfter(builder.getText(), offset) || this.myInsertNewLineBetweenNodes)) {
                builder.insertText(offset, "\n" + indentStr, false);
                offset += indentStr.length() + 1;
            }
            if (end != -1 || e >= offset) continue;
            end = e;
        }
        if (shouldNotReformatTemplate) {
            builder.setIsToReformat(false);
        }
        TemplateImpl templateImpl = builder.buildTemplate();
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "generate"));
        }
        return templateImpl;
    }

    private static TemplateImpl invokeTemplate(TemplateToken token, boolean hasChildren, CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator) {
        TemplateImpl template = token.getTemplate();
        if (generator != null) {
            assert (template != null);
            template = generator.generateTemplate(token, hasChildren, callback.getContext());
            GenerationNode.removeVariablesWhichHasNoSegment(template);
        }
        return template;
    }

    private TemplateImpl invokeXmlTemplate(TemplateToken token, CustomTemplateCallback callback, @Nullable ZenCodingGenerator generator, boolean hasChildren, List<Pair<String, String>> attr2value) {
        TemplateImpl template = token.getTemplate();
        assert (template != null);
        XmlFile xmlFile = token.getFile();
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)xmlFile.getProject());
        XmlFile dummyFile = (XmlFile)fileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)xmlFile.getText());
        XmlTag tag = dummyFile.getRootTag();
        if (tag != null) {
            for (Pair<String, String> pair : attr2value) {
                if (!Strings.isNullOrEmpty((String)((String)pair.second))) continue;
                template.addVariable(GenerationNode.prepareVariableName((String)pair.first), "", "", true);
            }
            XmlTag tag1 = hasChildren ? GenerationNode.expandEmptyTagIfNecessary(tag) : tag;
            this.setAttributeValues(tag1, attr2value);
            XmlFile physicalFile = (XmlFile)fileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)tag1.getContainingFile().getText(), LocalTimeCounter.currentTime(), true);
            VirtualFile vFile = physicalFile.getVirtualFile();
            if (vFile != null) {
                vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
            }
            token.setFile(physicalFile);
        }
        ZenCodingGenerator zenCodingGenerator = generator != null ? generator : XmlZenCodingGeneratorImpl.INSTANCE;
        template = zenCodingGenerator.generateTemplate(token, hasChildren, callback.getContext());
        GenerationNode.removeVariablesWhichHasNoSegment(template);
        return template;
    }

    private static String prepareVariableName(@NotNull String attributeName) {
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "prepareVariableName"));
        }
        return StringUtil.replaceChar((String)attributeName, (char)'-', (char)'_');
    }

    @NotNull
    private static TemplateImpl expandTemplate(@NotNull TemplateImpl template, Map<String, String> predefinedVarValues, String surroundedText) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandTemplate"));
        }
        LiveTemplateBuilder builder = new LiveTemplateBuilder();
        if (predefinedVarValues == null && surroundedText == null) {
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandTemplate"));
            }
            return templateImpl;
        }
        int offset = builder.insertTemplate(0, template, predefinedVarValues);
        if (surroundedText != null) {
            builder.insertText(offset, surroundedText, true);
            builder.setIsToReformat(true);
        }
        TemplateImpl templateImpl = builder.buildTemplate();
        if (templateImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandTemplate"));
        }
        return templateImpl;
    }

    @NotNull
    private static XmlTag expandEmptyTagIfNecessary(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandEmptyTagIfNecessary"));
        }
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (PsiElement child : tag.getChildren()) {
            if (child instanceof XmlToken && XmlTokenType.XML_EMPTY_ELEMENT_END.equals(((XmlToken)child).getTokenType())) {
                flag = true;
                break;
            }
            builder.append(child.getText());
        }
        if (flag) {
            builder.append("></").append(tag.getName()).append('>');
            XmlTag xmlTag = XmlElementFactory.getInstance((Project)tag.getProject()).createTagFromText((CharSequence)builder.toString(), (Language)XMLLanguage.INSTANCE);
            if (xmlTag == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandEmptyTagIfNecessary"));
            }
            return xmlTag;
        }
        XmlTag xmlTag = tag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/GenerationNode", "expandEmptyTagIfNecessary"));
        }
        return xmlTag;
    }

    private static int gotoChild(Project project, CharSequence text, int offset, int start, int end) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, text, LocalTimeCounter.currentTime(), false);
        PsiElement element = file.findElementAt(offset);
        if (offset < end && element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_END_TAG_START) {
            return offset;
        }
        int newOffset = -1;
        XmlTag tag = (XmlTag)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)start, (int)end, XmlTag.class);
        if (tag != null) {
            for (PsiElement child : tag.getChildren()) {
                if (!(child instanceof XmlToken) || ((XmlToken)child).getTokenType() != XmlTokenType.XML_END_TAG_START) continue;
                newOffset = child.getTextOffset();
            }
        }
        if (newOffset >= 0) {
            return newOffset;
        }
        return offset;
    }

    private static void removeVariablesWhichHasNoSegment(TemplateImpl template) {
        int i;
        HashSet segments = new HashSet();
        for (i = 0; i < template.getSegmentsCount(); ++i) {
            segments.add(template.getSegmentName(i));
        }
        for (i = template.getVariableCount() - 1; i >= 0; --i) {
            String varName = template.getVariableNameAt(i);
            if (!segments.contains(varName)) {
                template.removeVariable(i);
                continue;
            }
            segments.remove(varName);
        }
    }

    @Nullable
    private Map<String, String> buildPredefinedValues(List<Pair<String, String>> attribute2value, @Nullable XmlZenCodingGenerator generator, boolean hasChildren) {
        String attributes;
        if (generator == null) {
            return Collections.emptyMap();
        }
        for (Pair<String, String> pair : attribute2value) {
            if (!ZenCodingUtil.containsSurroundedTextMarker((String)pair.second)) continue;
            this.myContainsSurroundedTextMarker = true;
            break;
        }
        attributes = (attributes = generator.buildAttributesString(attribute2value, hasChildren, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText)).length() > 0 ? ' ' + attributes : null;
        HashMap predefinedValues = null;
        if (attributes != null) {
            predefinedValues = new HashMap();
            predefinedValues.put("ATTRS", attributes);
        }
        return predefinedValues;
    }

    private void setAttributeValues(XmlTag tag, List<Pair<String, String>> attr2value) {
        Iterator<Pair<String, String>> iterator = attr2value.iterator();
        while (iterator.hasNext()) {
            Pair<String, String> pair = iterator.next();
            if (tag.getAttribute((String)pair.first) == null) continue;
            if (ZenCodingUtil.containsSurroundedTextMarker((String)pair.second)) {
                this.myContainsSurroundedTextMarker = true;
            }
            tag.setAttribute((String)pair.first, Strings.isNullOrEmpty((String)((String)pair.second)) ? "$" + GenerationNode.prepareVariableName((String)pair.first) + "$" : ZenCodingUtil.getValue((String)pair.second, this.myNumberInIteration, this.myTotalIterations, this.mySurroundedText));
            iterator.remove();
        }
    }

    private static boolean isNewLineBefore(CharSequence text, int offset) {
        int i;
        for (i = offset - 1; i >= 0 && Character.isWhitespace(text.charAt(i)); --i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i < 0;
    }

    private static boolean isNewLineAfter(CharSequence text, int offset) {
        int i;
        for (i = offset; i < text.length() && Character.isWhitespace(text.charAt(i)); ++i) {
            if (text.charAt(i) != '\n') continue;
            return true;
        }
        return i == text.length();
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    public String getSurroundedText() {
        return this.mySurroundedText;
    }

    public void setSurroundedText(String surroundedText) {
        this.mySurroundedText = surroundedText;
    }

    public GenerationNode getParent() {
        return this.myParent;
    }

    public void setParent(GenerationNode parent) {
        this.myParent = parent;
    }
}

