/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.google.common.base.Strings;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentZenCodingFilter
extends ZenCodingFilter {
    private static String buildCommentString(@Nullable String classAttr, @Nullable String idAttr) {
        StringBuilder builder = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)idAttr)) {
            builder.append('#').append(idAttr);
        }
        if (!Strings.isNullOrEmpty((String)classAttr)) {
            builder.append('.').append(classAttr);
        }
        return builder.toString();
    }

    @Override
    @NotNull
    public String filterText(@NotNull String text, @NotNull TemplateToken token) {
        XmlTag tag;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter", "filterText"));
        }
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter", "filterText"));
        }
        XmlDocument document = token.getFile().getDocument();
        if (document != null && (tag = document.getRootTag()) != null) {
            String classAttr = tag.getAttributeValue("class");
            String idAttr = tag.getAttributeValue("id");
            if (!Strings.isNullOrEmpty((String)classAttr) || !Strings.isNullOrEmpty((String)idAttr)) {
                String commentString = CommentZenCodingFilter.buildCommentString(classAttr, idAttr);
                String string = text + "\n<!-- /" + commentString + " -->";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter", "filterText"));
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter", "filterText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSuffix() {
        if ("c" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter", "getSuffix"));
        }
        return "c";
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/filters/CommentZenCodingFilter", "isMyContext"));
        }
        return context.getLanguage() instanceof XMLLanguage;
    }
}

