/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.tokens.IdentifierToken;
import com.intellij.codeInsight.template.emmet.tokens.NumberToken;
import com.intellij.codeInsight.template.emmet.tokens.OperationToken;
import com.intellij.codeInsight.template.emmet.tokens.StringLiteralToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingTokens;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetLexer {
    private static final String DELIMS = ">^+*|()[]{}.#,='\" \u0000";

    @Nullable
    public List<ZenCodingToken> lex(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/EmmetLexer", "lex"));
        }
        text = text + '\u0000';
        ArrayList<ZenCodingToken> result = new ArrayList<ZenCodingToken>();
        boolean inQuotes = false;
        boolean inApostrophes = false;
        int bracesStack = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (inQuotes) {
                builder.append(c);
                if (c != '\"') continue;
                inQuotes = false;
                result.add(new StringLiteralToken(builder.toString()));
                builder = new StringBuilder();
                continue;
            }
            if (inApostrophes) {
                builder.append(c);
                if (c != '\'') continue;
                inApostrophes = false;
                result.add(new StringLiteralToken(builder.toString()));
                builder = new StringBuilder();
                continue;
            }
            if (bracesStack > 0) {
                builder.append(c);
                if (c == '}') {
                    if (--bracesStack != 0) continue;
                    result.add(new TextToken(builder.toString()));
                    builder = new StringBuilder();
                    continue;
                }
                if (c != '{') continue;
                ++bracesStack;
                continue;
            }
            if (DELIMS.indexOf(c) < 0) {
                builder.append(c);
                continue;
            }
            if (c == '+' && (i == text.length() - 2 || text.charAt(i + 1) == ')')) {
                builder.append(c);
                continue;
            }
            if (builder.length() > 0) {
                String tokenText = builder.toString();
                int n = StringUtil.parseInt((String)tokenText, (int)-1);
                if (!StringUtil.startsWithChar((CharSequence)tokenText, (char)'0') && n >= 0) {
                    result.add(new NumberToken(n));
                } else {
                    result.add(new IdentifierToken(tokenText));
                }
                builder = new StringBuilder();
            }
            if (c == '\"') {
                inQuotes = true;
                builder.append(c);
                continue;
            }
            if (c == '\'') {
                inApostrophes = true;
                builder.append(c);
                continue;
            }
            if (c == '{') {
                bracesStack = 1;
                builder.append(c);
                continue;
            }
            if (c == '(') {
                result.add(ZenCodingTokens.OPENING_R_BRACKET);
                continue;
            }
            if (c == ')') {
                result.add(ZenCodingTokens.CLOSING_R_BRACKET);
                continue;
            }
            if (c == '[') {
                result.add(ZenCodingTokens.OPENING_SQ_BRACKET);
                continue;
            }
            if (c == ']') {
                result.add(ZenCodingTokens.CLOSING_SQ_BRACKET);
                continue;
            }
            if (c == '=') {
                result.add(ZenCodingTokens.EQ);
                continue;
            }
            if (c == '.') {
                result.add(ZenCodingTokens.DOT);
                continue;
            }
            if (c == '#') {
                result.add(ZenCodingTokens.SHARP);
                continue;
            }
            if (c == ',') {
                result.add(ZenCodingTokens.COMMA);
                continue;
            }
            if (c == ' ') {
                result.add(ZenCodingTokens.SPACE);
                continue;
            }
            if (c == '|') {
                result.add(ZenCodingTokens.PIPE);
                continue;
            }
            if (c == '\u0000') continue;
            result.add(new OperationToken(c));
        }
        if (bracesStack != 0 || inQuotes || inApostrophes) {
            return null;
        }
        return result;
    }
}

