/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.template.ExpressionUtil");

    private ExpressionUtil() {
    }

    @Nullable
    public static String[] getNames(ExpressionContext context) {
        final Project project = context.getProject();
        final int offset = context.getStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String[] names = null;
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiIdentifier) {
            names = ExpressionUtil.getNamesForIdentifier(project, (PsiIdentifier)element);
        } else {
            final PsiFile fileCopy = (PsiFile)file.copy();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    BlockSupport blockSupport = BlockSupport.getInstance(project);
                    try {
                        blockSupport.reparseRange(fileCopy, offset, offset, "xxx");
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            PsiElement identifierCopy = fileCopy.findElementAt(offset);
            if (identifierCopy instanceof PsiIdentifier) {
                names = ExpressionUtil.getNamesForIdentifier(project, (PsiIdentifier)identifierCopy);
            }
        }
        return names;
    }

    @Nullable
    private static String[] getNamesForIdentifier(Project project, PsiIdentifier identifier) {
        PsiVariable var;
        if (identifier.getParent() instanceof PsiVariable && identifier.equals((var = (PsiVariable)identifier.getParent()).getNameIdentifier())) {
            PsiForeachStatement foreachStatement;
            PsiExpression iteratedValue;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            VariableKind variableKind = codeStyleManager.getVariableKind(var);
            PsiExpression initializer = var.getInitializer();
            if (var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiForeachStatement && (iteratedValue = (foreachStatement = (PsiForeachStatement)((PsiParameter)var).getDeclarationScope()).getIteratedValue()) != null) {
                try {
                    PsiArrayAccessExpression expr = (PsiArrayAccessExpression)JavaPsiFacade.getInstance((Project)iteratedValue.getProject()).getElementFactory().createExpressionFromText("a[0]", (PsiElement)var);
                    expr.getArrayExpression().replace((PsiElement)iteratedValue);
                    initializer = expr;
                }
                catch (IncorrectOperationException e) {
                    // empty catch block
                }
            }
            SuggestedNameInfo suggestedInfo = codeStyleManager.suggestVariableName(variableKind, null, initializer, var.getType());
            return suggestedInfo.names;
        }
        return null;
    }
}

