/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomTemplateCallback {
    private final TemplateManager myTemplateManager;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myOffset;
    private final Project myProject;
    private final boolean myInInjectedFragment;
    private Set<TemplateContextType> myApplicableContextTypes;

    public CustomTemplateCallback(@NotNull Editor editor, @NotNull PsiFile file, boolean wrapping) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/CustomTemplateCallback", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/CustomTemplateCallback", "<init>"));
        }
        this.myProject = file.getProject();
        this.myTemplateManager = TemplateManager.getInstance(this.myProject);
        this.myOffset = CustomTemplateCallback.getOffset(wrapping, editor);
        PsiElement element = InjectedLanguageUtil.findInjectedElementNoCommit(file, this.myOffset);
        this.myFile = element != null ? element.getContainingFile() : file;
        this.myInInjectedFragment = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(this.myFile);
        this.myEditor = this.myInInjectedFragment ? InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, file, this.myOffset) : editor;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = CustomTemplateCallback.getContext(this.myFile, this.myOffset);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        return psiElement;
    }

    public int getOffset() {
        return this.myOffset;
    }

    private static int getOffset(boolean wrapping, Editor editor) {
        if (wrapping) {
            return editor.getSelectionModel().getSelectionStart();
        }
        int caretOffset = editor.getCaretModel().getOffset();
        return caretOffset > 0 ? caretOffset - 1 : 0;
    }

    @Nullable
    public TemplateImpl findApplicableTemplate(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/CustomTemplateCallback", "findApplicableTemplate"));
        }
        List<TemplateImpl> templates = this.findApplicableTemplates(key);
        return templates.size() > 0 ? templates.get(0) : null;
    }

    @NotNull
    public List<TemplateImpl> findApplicableTemplates(@NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/CustomTemplateCallback", "findApplicableTemplates"));
        }
        ArrayList<TemplateImpl> result = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : CustomTemplateCallback.getMatchingTemplates(key)) {
            if (!this.isAvailableTemplate(candidate)) continue;
            result.add(candidate);
        }
        ArrayList<TemplateImpl> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "findApplicableTemplates"));
        }
        return arrayList;
    }

    private boolean isAvailableTemplate(TemplateImpl template) {
        if (this.myApplicableContextTypes == null) {
            this.myApplicableContextTypes = TemplateManagerImpl.getApplicableContextTypes(this.myFile, this.myOffset);
        }
        return !template.isDeactivated() && TemplateManagerImpl.isApplicable(template, this.myApplicableContextTypes);
    }

    public void startTemplate(Template template, Map<String, String> predefinedValues, TemplateEditingListener listener) {
        if (this.myInInjectedFragment) {
            template.setToReformat(false);
        }
        this.myTemplateManager.startTemplate(this.myEditor, template, false, predefinedValues, listener);
    }

    public void startTemplate() {
        Map<TemplateImpl, String> template2Argument = ((TemplateManagerImpl)this.myTemplateManager).findMatchingTemplates(this.myFile, this.myEditor, null, TemplateSettings.getInstance());
        Runnable runnable = ((TemplateManagerImpl)this.myTemplateManager).startNonCustomTemplates(template2Argument, this.myEditor, null);
        if (runnable != null) {
            runnable.run();
        }
    }

    private static List<TemplateImpl> getMatchingTemplates(@NotNull String templateKey) {
        if (templateKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/CustomTemplateCallback", "getMatchingTemplates"));
        }
        TemplateSettings settings = TemplateSettings.getInstance();
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : settings.getTemplates(templateKey)) {
            if (template.isDeactivated()) continue;
            candidates.add(template);
        }
        return candidates;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getEditor"));
        }
        return editor;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFile.getFileType();
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getFileType"));
        }
        return fileType;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void deleteTemplateKey(String key) {
        int caretAt = this.myEditor.getCaretModel().getOffset();
        this.myEditor.getDocument().deleteString(caretAt - key.length(), caretAt);
    }

    @NotNull
    public static PsiElement getContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        PsiElement element = null;
        if (!InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            element = InjectedLanguageUtil.findInjectedElementNoCommit(file, offset);
        }
        if (element == null) {
            element = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset);
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/CustomTemplateCallback", "getContext"));
        }
        return psiElement;
    }

    public boolean isInInjectedFragment() {
        return this.myInInjectedFragment;
    }
}

