/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementPreviewHintProvider
implements ElementPreviewProvider {
    private static final Logger LOG = Logger.getInstance(ElementPreviewHintProvider.class);
    private static final int HINT_HIDE_FLAGS = 122;
    @Nullable
    private LightweightHint hint;

    public boolean isSupportedFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/preview/ElementPreviewHintProvider", "isSupportedFile"));
        }
        for (PreviewHintProvider hintProvider : (PreviewHintProvider[])Extensions.getExtensions((ExtensionPointName)PreviewHintProvider.EP_NAME)) {
            if (!hintProvider.isSupportedFile(psiFile)) continue;
            return true;
        }
        return false;
    }

    public void show(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Point point, boolean keyTriggered) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/preview/ElementPreviewHintProvider", "show"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/preview/ElementPreviewHintProvider", "show"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/preview/ElementPreviewHintProvider", "show"));
        }
        LightweightHint newHint = ElementPreviewHintProvider.getHint(element);
        this.hideCurrentHintIfAny();
        if (newHint == null) {
            return;
        }
        this.hint = newHint;
        HintManagerImpl.getInstanceImpl().showEditorHint(newHint, editor, HintManagerImpl.getHintPosition(newHint, editor, editor.xyToLogicalPosition(point), (short)5), 122, 0, false);
    }

    private void hideCurrentHintIfAny() {
        if (this.hint != null) {
            this.hint.hide();
            this.hint = null;
        }
    }

    public void hide(@Nullable PsiElement element, @NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/preview/ElementPreviewHintProvider", "hide"));
        }
        this.hideCurrentHintIfAny();
    }

    @Nullable
    private static LightweightHint getHint(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/preview/ElementPreviewHintProvider", "getHint"));
        }
        for (PreviewHintProvider hintProvider : (PreviewHintProvider[])Extensions.getExtensions((ExtensionPointName)PreviewHintProvider.EP_NAME)) {
            JComponent preview;
            try {
                preview = hintProvider.getPreviewComponent(element);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            if (preview == null) continue;
            return new LightweightHint(preview);
        }
        return null;
    }
}

