/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.PreviewHintComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorPreviewComponent
extends JComponent
implements PreviewHintComponent {
    @NotNull
    private final Color myColor;

    public ColorPreviewComponent(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/preview/ColorPreviewComponent", "<init>"));
        }
        this.myColor = color;
        this.setOpaque(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = this.getBounds();
        g2.setPaint(this.myColor);
        g2.fillRect(1, 1, r.width - 2, r.height - 2);
        g2.setPaint(Color.BLACK);
        g2.drawRect(0, 0, r.width - 1, r.height - 1);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(70, 25);
    }

    @Override
    public boolean isEqualTo(@Nullable PreviewHintComponent other) {
        return other instanceof ColorPreviewComponent && this.myColor.equals(((ColorPreviewComponent)other).myColor);
    }
}

