/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.ui.JBListWithHintProvider;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtil {
    private NavigationUtil() {
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, String title) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, new DefaultPsiElementCellRenderer(), title);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, @NotNull PsiElementListCellRenderer<PsiElement> renderer, String title) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup((PsiElement[])elements, renderer, (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil$1", "execute"));
                }
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)element);
                if (descriptor != null && descriptor.canNavigate()) {
                    descriptor.navigate(true);
                }
                return true;
            }
        });
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, String title, @NotNull PsiElementProcessor<T> processor) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBPopup jBPopup = NavigationUtil.getPsiElementPopup(elements, renderer, (String)title, processor, null);
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, @Nullable String title, @NotNull PsiElementProcessor<T> processor, @Nullable T selection) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        JBListWithHintProvider list = new JBListWithHintProvider(elements){

            @Nullable
            protected PsiElement getPsiElementForHint(Object selectedValue) {
                return (PsiElement)selectedValue;
            }
        };
        list.setCellRenderer(renderer);
        if (selection != null) {
            list.setSelectedValue(selection, true);
        }
        Runnable runnable = new Runnable((JList)list, processor){
            final /* synthetic */ JList val$list;
            final /* synthetic */ PsiElementProcessor val$processor;
            {
                this.val$list = jList;
                this.val$processor = psiElementProcessor;
            }

            @Override
            public void run() {
                int[] ids = this.val$list.getSelectedIndices();
                if (ids == null || ids.length == 0) {
                    return;
                }
                for (Object element : this.val$list.getSelectedValues()) {
                    if (element == null) continue;
                    this.val$processor.execute((PsiElement)element);
                }
            }
        };
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        if (title != null) {
            builder.setTitle(title);
        }
        renderer.installSpeedSearch(builder, true);
        JBPopup jBPopup = builder.setItemChoosenCallback(runnable).createPopup();
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/navigation/NavigationUtil", "getPsiElementPopup"));
        }
        return jBPopup;
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "activateFileWithPsiElement"));
        }
        return NavigationUtil.activateFileWithPsiElement(elt, true);
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt, boolean searchForOpen) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "activateFileWithPsiElement"));
        }
        return NavigationUtil.openFileWithPsiElement(elt, searchForOpen, true);
    }

    public static boolean openFileWithPsiElement(PsiElement element, boolean searchForOpen, boolean requestFocus) {
        VirtualFile virtualFile;
        boolean openAsNative = false;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            openAsNative = ElementBase.isNativeFileType((FileType)virtualFile.getFileType());
        }
        if (searchForOpen) {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        } else {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)true);
        }
        if (openAsNative || !NavigationUtil.activatePsiElementIfOpen(element, searchForOpen, requestFocus)) {
            NavigationItem navigationItem = (NavigationItem)element;
            if (!navigationItem.canNavigate()) {
                return false;
            }
            navigationItem.navigate(requestFocus);
            return true;
        }
        element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        return false;
    }

    private static boolean activatePsiElementIfOpen(@NotNull PsiElement elt, boolean searchForOpen, boolean requestFocus) {
        FileEditor[] editors;
        TextRange range;
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/NavigationUtil", "activatePsiElementIfOpen"));
        }
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file = (elt = elt.getNavigationElement()).getContainingFile();
        if (file == null || !file.isValid()) {
            return false;
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (!EditorHistoryManager.getInstance(elt.getProject()).hasBeenOpen(vFile)) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance((Project)elt.getProject());
        if (!fem.isFileOpen(vFile)) {
            fem.openFile(vFile, requestFocus, searchForOpen);
        }
        if ((range = elt.getTextRange()) == null) {
            return false;
        }
        for (FileEditor editor : editors = fem.getEditors(vFile)) {
            Editor text;
            int offset;
            if (!(editor instanceof TextEditor) || !range.containsOffset(offset = (text = ((TextEditor)editor).getEditor()).getCaretModel().getOffset())) continue;
            fem.openFile(vFile, requestFocus, searchForOpen);
            return true;
        }
        return false;
    }
}

