/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class MethodDownHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int[] offsets;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/MethodDownHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/MethodDownHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/navigation/MethodDownHandler", "invoke"));
        }
        LookupManager.getInstance(project).hideActiveLookup();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int caretOffset = editor.getCaretModel().getOffset();
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (int offset : offsets = MethodUpDownUtil.getNavigationOffsets(file, caretOffset)) {
            int line;
            if (offset <= caretOffset || (line = editor.offsetToLogicalPosition((int)offset).line) <= caretLine) continue;
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            break;
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

