/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaGotoSuperHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/navigation/JavaGotoSuperHandler", "invoke"));
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.super");
        int offset = editor.getCaretModel().getOffset();
        PsiElement[] superElements = this.findSuperElements(file, offset);
        if (superElements == null || superElements.length == 0) {
            return;
        }
        if (superElements.length == 1) {
            PsiElement superElement = superElements[0].getNavigationElement();
            PsiFile containingFile = superElement.getContainingFile();
            if (containingFile == null) {
                return;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, superElement.getTextOffset());
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor, true);
        } else if (superElements[0] instanceof PsiMethod) {
            boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])((PsiMethod[])superElements));
            PsiElementListNavigator.openTargets(editor, (NavigatablePsiElement[])((PsiMethod[])superElements), CodeInsightBundle.message((String)"goto.super.method.chooser.title", (Object[])new Object[0]), CodeInsightBundle.message((String)"goto.super.method.findUsages.title", (Object[])new Object[]{((PsiMethod)superElements[0]).getName()}), (ListCellRenderer)new MethodCellRenderer(showMethodNames));
        } else {
            NavigationUtil.getPsiElementPopup(superElements, CodeInsightBundle.message((String)"goto.super.class.chooser.title", (Object[])new Object[0])).showInBestPositionFor(editor);
        }
    }

    @Nullable
    private PsiElement[] findSuperElements(PsiFile file, int offset) {
        PsiMethod interfaceMethod;
        PsiElement element = this.getElement(file, offset);
        if (element == null) {
            return null;
        }
        PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiLambdaExpression.class, PsiMethodReferenceExpression.class});
        if (expression != null && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)expression)) != null) {
            return (PsiElement[])ArrayUtil.prepend((Object)interfaceMethod, (Object[])interfaceMethod.findSuperMethods(false));
        }
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            return null;
        }
        return FindSuperElementsHelper.findSuperElements((PsiElement)parent);
    }

    protected PsiElement getElement(PsiFile file, int offset) {
        return file.findElementAt(offset);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

