/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.reference.SoftReference;
import com.intellij.util.PatchedWeakReference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDocumentationTooltipAction
extends AnAction {
    @Nullable
    private WeakReference<PsiElement> myDocAnchor;
    @Nullable
    private WeakReference<PsiElement> myOriginalElement;

    public void setDocInfo(@NotNull PsiElement docAnchor, @NotNull PsiElement originalElement) {
        if (docAnchor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/navigation/AbstractDocumentationTooltipAction", "setDocInfo"));
        }
        if (originalElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/navigation/AbstractDocumentationTooltipAction", "setDocInfo"));
        }
        this.myDocAnchor = new PatchedWeakReference<PsiElement>(docAnchor);
        this.myOriginalElement = new PatchedWeakReference<PsiElement>(originalElement);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(this.getDocInfo() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Pair<PsiElement, PsiElement> info = this.getDocInfo();
        if (info == null) {
            return;
        }
        this.doActionPerformed(e.getDataContext(), (PsiElement)info.first, (PsiElement)info.second);
        this.myDocAnchor = null;
        this.myOriginalElement = null;
    }

    protected abstract void doActionPerformed(@NotNull DataContext var1, @NotNull PsiElement var2, @NotNull PsiElement var3);

    @Nullable
    private Pair<PsiElement, PsiElement> getDocInfo() {
        PsiElement docAnchor = (PsiElement)SoftReference.dereference(this.myDocAnchor);
        if (docAnchor == null) {
            return null;
        }
        PsiElement originalElement = (PsiElement)SoftReference.dereference(this.myOriginalElement);
        if (originalElement == null) {
            return null;
        }
        return Pair.create((Object)docAnchor, (Object)originalElement);
    }
}

