/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl.actions;

import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.SurroundWithTemplateHandler;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ChooseItemAction
extends EditorAction {
    public ChooseItemAction(Handler handler) {
        super((EditorActionHandler)handler);
    }

    public static boolean hasTemplatePrefix(LookupImpl lookup, char shortcutChar) {
        lookup.refreshUi(false, false);
        CompletionProcess completion = CompletionService.getCompletionService().getCurrentCompletion();
        if (completion == null || !completion.isAutopopupCompletion()) {
            return false;
        }
        if (lookup.isSelectionTouched()) {
            return false;
        }
        PsiFile file = lookup.getPsiFile();
        if (file == null) {
            return false;
        }
        Editor editor = lookup.getEditor();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        LiveTemplateLookupElement liveTemplateLookup = (LiveTemplateLookupElement)((Object)ContainerUtil.findInstance(lookup.getItems(), LiveTemplateLookupElement.class));
        if (liveTemplateLookup == null || !liveTemplateLookup.sudden) {
            String prefix;
            CustomTemplateCallback callback = new CustomTemplateCallback(editor, file, false);
            for (CustomLiveTemplate customLiveTemplate : (CustomLiveTemplate[])CustomLiveTemplate.EP_NAME.getExtensions()) {
                if (!(customLiveTemplate instanceof CustomLiveTemplateBase)) continue;
                int offset = editor.getCaretModel().getOffset();
                if (customLiveTemplate.getShortcut() != shortcutChar || !TemplateManagerImpl.isApplicable(customLiveTemplate, editor, file) || !((CustomLiveTemplateBase)customLiveTemplate).hasCompletionItem(file, offset)) continue;
                return customLiveTemplate.computeTemplateKey(callback) != null;
            }
            int end = editor.getCaretModel().getOffset();
            int start = lookup.getLookupStart();
            String string = prefix = !lookup.getItems().isEmpty() ? editor.getDocument().getText(TextRange.create((int)start, (int)end)) : ListTemplatesHandler.getPrefix(editor.getDocument(), end, false);
            if (TemplateSettings.getInstance().getTemplates(prefix).isEmpty()) {
                return false;
            }
            for (TemplateImpl template : SurroundWithTemplateHandler.getApplicableTemplates(editor, file, false)) {
                if (!prefix.equals(template.getKey()) || shortcutChar != TemplateSettings.getInstance().getShortcutChar(template)) continue;
                return true;
            }
            return false;
        }
        return liveTemplateLookup.getTemplateShortcut() == shortcutChar;
    }

    public static class ChooseWithDot
    extends ChooseItemAction {
        public ChooseWithDot() {
            super(new Handler(false, '.'));
        }
    }

    public static class CompletingStatement
    extends ChooseItemAction {
        public CompletingStatement() {
            super(new Handler(true, '\r'));
        }
    }

    public static class Replacing
    extends ChooseItemAction {
        public Replacing() {
            super(new Handler(false, '\t'));
        }
    }

    public static class FocusedOnly
    extends ChooseItemAction {
        public FocusedOnly() {
            super(new Handler(true, '\n'));
        }
    }

    public static class Always
    extends ChooseItemAction {
        public Always() {
            super(new Handler(false, '\n'));
        }
    }

    protected static class Handler
    extends EditorActionHandler {
        final boolean focusedOnly;
        final char finishingChar;

        protected Handler(boolean focusedOnly, char finishingChar) {
            this.focusedOnly = focusedOnly;
            this.finishingChar = finishingChar;
        }

        public void execute(@NotNull Editor editor, DataContext dataContext) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/actions/ChooseItemAction$Handler", "execute"));
            }
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
            if (lookup == null) {
                throw new AssertionError((Object)("The last lookup disposed at: " + LookupImpl.getLastLookupDisposeTrace() + "\n-----------------------\n"));
            }
            if (this.finishingChar == '\n') {
                if (!lookup.isFocused()) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByControlEnter");
                }
            } else if (this.finishingChar == '\r') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishBySmartEnter");
            } else if (this.finishingChar == '\t') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.replace");
            } else if (this.finishingChar == '.') {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.finishByCtrlDot");
            }
            lookup.finishLookup(this.finishingChar);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(editor);
            if (lookup == null) {
                return false;
            }
            if (!lookup.isAvailableToUser()) {
                return false;
            }
            if (this.focusedOnly && lookup.getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED) {
                return false;
            }
            if (this.finishingChar == '\n' && ChooseItemAction.hasTemplatePrefix(lookup, '\n') || this.finishingChar == '\t' && ChooseItemAction.hasTemplatePrefix(lookup, '\t')) {
                return false;
            }
            if (this.finishingChar == '\t') {
                return !lookup.getItems().isEmpty();
            }
            return true;
        }
    }
}

