/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.completion.RangeMarkerSpy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class LookupOffsets {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupOffsets");
    private String myAdditionalPrefix = "";
    private String myInitialPrefix;
    private boolean myStableStart;
    private RangeMarker myLookupStartMarker;
    private int myRemovedPrefix;
    private final RangeMarker myLookupOriginalStartMarker;
    private final Editor myEditor;

    public LookupOffsets(Editor editor) {
        this.myEditor = editor;
        int caret = this.getPivotOffset();
        this.myLookupOriginalStartMarker = editor.getDocument().createRangeMarker(caret, caret);
        this.myLookupOriginalStartMarker.setGreedyToLeft(true);
        this.updateLookupStart(0);
    }

    private void updateLookupStart(int minPrefixLength) {
        int offset = this.getPivotOffset();
        int start = offset - minPrefixLength - this.myAdditionalPrefix.length() + this.myRemovedPrefix;
        if (start < 0) {
            LOG.error("Invalid start offset: o=" + offset + ", mpl=" + minPrefixLength + ", ap=" + this.myAdditionalPrefix + ", rp=" + this.myRemovedPrefix);
            return;
        }
        if (this.myLookupStartMarker != null) {
            if (this.myLookupStartMarker.isValid() && this.myLookupStartMarker.getStartOffset() == start && this.myLookupStartMarker.getEndOffset() == start) {
                return;
            }
            this.myLookupStartMarker.dispose();
        }
        this.myLookupStartMarker = this.myEditor.getDocument().createRangeMarker(start, start);
        this.myLookupStartMarker.setGreedyToLeft(true);
    }

    private int getPivotOffset() {
        return this.myEditor.getSelectionModel().hasSelection() ? this.myEditor.getSelectionModel().getSelectionStart() : this.myEditor.getCaretModel().getOffset();
    }

    public String getAdditionalPrefix() {
        return this.myAdditionalPrefix;
    }

    public void appendPrefix(char c) {
        this.myAdditionalPrefix = this.myAdditionalPrefix + c;
        this.myInitialPrefix = null;
    }

    public boolean truncatePrefix() {
        int len = this.myAdditionalPrefix.length();
        if (len == 0) {
            ++this.myRemovedPrefix;
            return false;
        }
        this.myAdditionalPrefix = this.myAdditionalPrefix.substring(0, len - 1);
        this.myInitialPrefix = null;
        return true;
    }

    void checkMinPrefixLengthChanges(Collection<LookupElement> items, LookupImpl lookup) {
        if (this.myStableStart) {
            return;
        }
        if (!lookup.isCalculating() && !items.isEmpty()) {
            this.myStableStart = true;
        }
        int minPrefixLength = items.isEmpty() ? 0 : Integer.MAX_VALUE;
        for (LookupElement item : items) {
            if (item instanceof EmptyLookupItem) continue;
            minPrefixLength = Math.min(lookup.itemMatcher(item).getPrefix().length(), minPrefixLength);
        }
        this.updateLookupStart(minPrefixLength);
    }

    int getLookupStart(String disposeTrace) {
        if (this.myLookupStartMarker == null) {
            LOG.error("disposed: " + disposeTrace);
        }
        if (!this.myLookupStartMarker.isValid()) {
            LOG.error("invalid marker: " + disposeTrace);
        }
        return this.myLookupStartMarker.getStartOffset();
    }

    int getLookupOriginalStart() {
        return this.myLookupOriginalStartMarker.isValid() ? this.myLookupOriginalStartMarker.getStartOffset() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean performGuardedChange(Runnable change, final @Nullable String debug) {
        if (this.myLookupStartMarker == null) {
            throw new AssertionError((Object)"null start before");
        }
        if (!this.myLookupStartMarker.isValid()) {
            throw new AssertionError((Object)"invalid start");
        }
        final Document document = this.myEditor.getDocument();
        RangeMarkerSpy spy = new RangeMarkerSpy(this.myLookupStartMarker){

            @Override
            protected void invalidated(DocumentEvent e) {
                LOG.info("Lookup start marker invalidated, say thanks to the " + e + ", doc=" + document + ", debug=" + debug);
            }
        };
        document.addDocumentListener((DocumentListener)spy);
        try {
            change.run();
        }
        finally {
            document.removeDocumentListener((DocumentListener)spy);
        }
        return this.myLookupStartMarker.isValid();
    }

    void setInitialPrefix(String presentPrefix, boolean explicitlyInvoked) {
        this.myInitialPrefix = this.myAdditionalPrefix.length() == 0 && this.myInitialPrefix == null && !explicitlyInvoked ? presentPrefix : null;
    }

    void clearAdditionalPrefix() {
        this.myAdditionalPrefix = "";
        this.myRemovedPrefix = 0;
    }

    void restorePrefix(int lookupStart) {
        if (this.myInitialPrefix != null) {
            this.myEditor.getDocument().replaceString(lookupStart, this.myEditor.getCaretModel().getOffset(), (CharSequence)this.myInitialPrefix);
        }
    }

    public void disposeMarkers() {
        if (this.myLookupStartMarker != null) {
            this.myLookupStartMarker.dispose();
            this.myLookupStartMarker = null;
        }
        this.myLookupOriginalStartMarker.dispose();
    }

    public int getPrefixLength(LookupElement item, LookupImpl lookup) {
        return lookup.itemPattern(item).length() - this.myRemovedPrefix;
    }
}

