/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup.impl;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBus;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.jetbrains.annotations.NotNull;

public class LookupManagerImpl
extends LookupManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.lookup.impl.LookupManagerImpl");
    private final Project myProject;
    private LookupImpl myActiveLookup = null;
    private Editor myActiveLookupEditor = null;
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);

    public LookupManagerImpl(Project project, MessageBus bus) {
        this.myProject = project;
        bus.connect().subscribe(EditorHintListener.TOPIC, (Object)new EditorHintListener(){

            @Override
            public void hintShown(Project project, final LightweightHint hint, int flags) {
                LookupEx lookup;
                if (project == LookupManagerImpl.this.myProject && (lookup = LookupManagerImpl.this.getActiveLookup()) != null && (flags & 4) != 0) {
                    lookup.addLookupListener(new LookupAdapter(){

                        @Override
                        public void currentItemChanged(LookupEvent event) {
                            hint.hide();
                        }

                        @Override
                        public void itemSelected(LookupEvent event) {
                            hint.hide();
                        }

                        @Override
                        public void lookupCanceled(LookupEvent event) {
                            hint.hide();
                        }
                    });
                }
            }
        });
        bus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                LookupManagerImpl.this.hideActiveLookup();
            }

            public void exitDumbMode() {
                LookupManagerImpl.this.hideActiveLookup();
            }
        });
        EditorFactoryAdapter myEditorFactoryListener = new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl$3", "editorReleased"));
                }
                if (event.getEditor() == LookupManagerImpl.this.myActiveLookupEditor) {
                    LookupManagerImpl.this.hideActiveLookup();
                }
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)myEditorFactoryListener, (Disposable)this.myProject);
    }

    @Override
    public LookupEx showLookup(@NotNull Editor editor, @NotNull LookupElement[] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "showLookup"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "showLookup"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "showLookup"));
        }
        if (arranger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "showLookup"));
        }
        for (LookupElement item : items) {
            assert (item != null);
        }
        LookupImpl lookup = this.createLookup(editor, items, prefix, arranger);
        return lookup.showLookup() ? lookup : null;
    }

    @Override
    @NotNull
    public LookupImpl createLookup(final @NotNull Editor editor, @NotNull LookupElement[] items, @NotNull String prefix, @NotNull LookupArranger arranger) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "createLookup"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "createLookup"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "createLookup"));
        }
        if (arranger == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "createLookup"));
        }
        this.hideActiveLookup();
        final CodeInsightSettings settings = CodeInsightSettings.getInstance();
        final PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        final LookupImpl lookup = new LookupImpl(this.myProject, editor, arranger);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).disableUpdateByTimer((Disposable)lookup);
        final Alarm alarm = new Alarm();
        final Runnable request = new Runnable(){

            @Override
            public void run() {
                CompletionProcess completion;
                if (LookupManagerImpl.this.myActiveLookup != lookup) {
                    return;
                }
                LookupElement currentItem = lookup.getCurrentItem();
                if (currentItem != null && currentItem.isValid() && (completion = CompletionService.getCompletionService().getCurrentCompletion()) != null && !completion.isAutopopupCompletion()) {
                    try {
                        DocumentationManager.getInstance(LookupManagerImpl.this.myProject).showJavaDocInfo(editor, psiFile, false);
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                }
            }
        };
        if (settings.AUTO_POPUP_JAVADOC_INFO) {
            alarm.addRequest(request, settings.JAVADOC_INFO_DELAY);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myActiveLookup = lookup;
        this.myActiveLookupEditor = editor;
        this.myActiveLookup.addLookupListener(new LookupAdapter(){

            @Override
            public void itemSelected(LookupEvent event) {
                this.lookupClosed();
            }

            @Override
            public void lookupCanceled(LookupEvent event) {
                this.lookupClosed();
            }

            @Override
            public void currentItemChanged(LookupEvent event) {
                alarm.cancelAllRequests();
                if (settings.AUTO_POPUP_JAVADOC_INFO) {
                    alarm.addRequest(request, settings.JAVADOC_INFO_DELAY);
                }
            }

            private void lookupClosed() {
                ApplicationManager.getApplication().assertIsDispatchThread();
                alarm.cancelAllRequests();
                LookupImpl lookup = LookupManagerImpl.this.myActiveLookup;
                if (lookup == null) {
                    return;
                }
                LOG.assertTrue(lookup.isLookupDisposed());
                LookupManagerImpl.this.myActiveLookup = null;
                LookupManagerImpl.this.myActiveLookupEditor = null;
                lookup.removeLookupListener(this);
                LookupManagerImpl.this.myPropertyChangeSupport.firePropertyChange("activeLookup", lookup, null);
            }
        });
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix);
        if (items.length > 0) {
            for (LookupElement item : items) {
                this.myActiveLookup.addItem(item, matcher);
            }
            this.myActiveLookup.refreshUi(true, true);
        } else {
            alarm.cancelAllRequests();
        }
        this.myPropertyChangeSupport.firePropertyChange("activeLookup", null, this.myActiveLookup);
        LookupImpl lookupImpl = lookup;
        if (lookupImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "createLookup"));
        }
        return lookupImpl;
    }

    @Override
    public void hideActiveLookup() {
        LookupImpl lookup = this.myActiveLookup;
        if (lookup != null) {
            lookup.checkValid();
            lookup.hide();
            LOG.assertTrue(lookup.isLookupDisposed(), (Object)"Should be disposed");
        }
    }

    @Override
    public LookupEx getActiveLookup() {
        if (this.myActiveLookup != null && this.myActiveLookup.isLookupDisposed()) {
            LookupImpl lookup = this.myActiveLookup;
            this.myActiveLookup = null;
            lookup.checkValid();
        }
        return this.myActiveLookup;
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "addPropertyChangeListener"));
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(final @NotNull PropertyChangeListener listener, @NotNull Disposable disposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "addPropertyChangeListener"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "addPropertyChangeListener"));
        }
        this.addPropertyChangeListener(listener);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                LookupManagerImpl.this.removePropertyChangeListener(listener);
            }
        });
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/lookup/impl/LookupManagerImpl", "removePropertyChangeListener"));
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void forceSelection(char completion, int index) {
        if (this.myActiveLookup == null) {
            throw new RuntimeException("There are no items in this lookup");
        }
        LookupElement lookupItem = this.myActiveLookup.getItems().get(index);
        this.myActiveLookup.setCurrentItem(lookupItem);
        this.myActiveLookup.finishLookup(completion);
    }

    public void forceSelection(char completion, LookupElement item) {
        this.myActiveLookup.setCurrentItem(item);
        this.myActiveLookup.finishLookup(completion);
    }

    public void clearLookup() {
        if (this.myActiveLookup != null) {
            this.myActiveLookup.hide();
            this.myActiveLookup = null;
        }
    }
}

