/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class XmlChooseColorIntentionAction
extends PsiElementBaseIntentionAction {
    public XmlChooseColorIntentionAction() {
        this.setText(CodeInsightBundle.message((String)"intention.color.chooser.dialog", (Object[])new Object[0]));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction", "isAvailable"));
        }
        PsiElement parent = element.getParent();
        return parent instanceof XmlAttributeValue && ColorUtil.fromHex((String)((XmlAttributeValue)parent).getValue(), null) != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intentions/XmlChooseColorIntentionAction", "invoke"));
        }
        XmlChooseColorIntentionAction.chooseColor(editor.getComponent(), element, this.getText(), false);
    }

    public static void chooseColor(JComponent editorComponent, PsiElement element, String caption, boolean startInWriteAction) {
        Color oldColor;
        final XmlAttributeValue literal = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)false);
        if (literal == null) {
            return;
        }
        String text = StringUtil.unquoteString((String)literal.getValue());
        try {
            oldColor = Color.decode(text);
        }
        catch (NumberFormatException e) {
            oldColor = JBColor.GRAY;
        }
        Color color = ColorChooser.chooseColor((Component)editorComponent, (String)caption, (Color)oldColor, (boolean)true);
        if (color == null) {
            return;
        }
        if (!Comparing.equal((Object)color, (Object)oldColor)) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            String newText = "#" + ColorUtil.toHex((Color)color);
            PsiManager manager = literal.getManager();
            final XmlAttribute newAttribute = XmlElementFactory.getInstance((Project)manager.getProject()).createXmlAttribute("name", newText);
            final Runnable replaceRunnable = new Runnable(){

                @Override
                public void run() {
                    XmlAttributeValue valueElement = newAttribute.getValueElement();
                    assert (valueElement != null);
                    literal.replace((PsiElement)valueElement);
                }
            };
            if (startInWriteAction) {
                new WriteCommandAction(element.getProject(), caption, new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        replaceRunnable.run();
                    }
                }.execute();
            } else {
                replaceRunnable.run();
            }
        }
    }
}

