/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ui.RangeBlinker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

class IntentionUsagePanel
extends JPanel {
    private final EditorEx myEditor = (EditorEx)IntentionUsagePanel.createEditor("", 10, 3, -1);
    @NonNls
    private static final String SPOT_MARKER = "spot";
    private final RangeBlinker myRangeBlinker;

    public IntentionUsagePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.myEditor.getComponent(), "Center");
        TextAttributes blinkAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        this.myRangeBlinker = new RangeBlinker((Editor)this.myEditor, blinkAttributes, Integer.MAX_VALUE);
    }

    public void reset(final String usageText, final FileType fileType) {
        this.reinitViews();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (IntentionUsagePanel.this.myEditor.isDisposed()) {
                    return;
                }
                DocumentUtil.writeInRunUndoTransparentAction(new Runnable(){

                    @Override
                    public void run() {
                        IntentionUsagePanel.this.configureByText(usageText, fileType);
                    }
                });
            }
        });
    }

    private void configureByText(String usageText, FileType fileType) {
        DocumentEx document = this.myEditor.getDocument();
        String text = StringUtil.convertLineSeparators((String)usageText);
        document.replaceString(0, document.getTextLength(), text);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myEditor.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(fileType, scheme, null));
        this.setupSpots(document);
    }

    private void setupSpots(Document document) {
        int spotEnd;
        String text;
        int spotStart;
        ArrayList<2> markers = new ArrayList<2>();
        while ((spotStart = (text = document.getText()).indexOf("<spot>")) >= 0 && (spotEnd = text.indexOf("</spot>", spotStart)) >= 0) {
            document.deleteString(spotEnd, spotEnd + SPOT_MARKER.length() + 3);
            document.deleteString(spotStart, spotStart + SPOT_MARKER.length() + 2);
            Segment spotMarker = new Segment(){

                public int getStartOffset() {
                    return spotStart;
                }

                public int getEndOffset() {
                    return spotEnd - IntentionUsagePanel.SPOT_MARKER.length() - 2;
                }
            };
            markers.add(spotMarker);
        }
        this.myRangeBlinker.resetMarkers(markers);
        if (!markers.isEmpty()) {
            this.myRangeBlinker.startBlinking();
        }
    }

    public void dispose() {
        this.myRangeBlinker.stopBlinking();
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myEditor);
    }

    private void reinitViews() {
        this.myEditor.reinitSettings();
        this.myEditor.getMarkupModel().removeAllHighlighters();
    }

    private static Editor createEditor(String text, int column, int line, int selectedLine) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)editorFactory.createViewer(editorDocument);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        editor.setColorsScheme(scheme);
        EditorSettings settings = editor.getSettings();
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        LogicalPosition pos = new LogicalPosition(line, column);
        editor.getCaretModel().moveToLogicalPosition(pos);
        if (selectedLine >= 0) {
            editor.getSelectionModel().setSelection(editorDocument.getLineStartOffset(selectedLine), editorDocument.getLineEndOffset(selectedLine));
        }
        return editor;
    }
}

