/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.impl.JavaTemplateUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class TypeExpression
extends Expression {
    private final LinkedHashSet<SmartTypePointer> myItems;

    public TypeExpression(Project project, PsiType[] types) {
        SmartTypePointerManager manager = SmartTypePointerManager.getInstance((Project)project);
        this.myItems = new LinkedHashSet();
        for (PsiType type : types) {
            this.myItems.add(manager.createSmartTypePointer(type));
        }
    }

    public Result calculateResult(ExpressionContext context) {
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (this.myItems.isEmpty()) {
            return null;
        }
        final PsiType type = ((SmartTypePointer)this.myItems.iterator().next()).getType();
        return type == null ? null : new PsiTypeResult(type, project){

            @Override
            public void handleRecalc(PsiFile psiFile, Document document, int segmentStart, int segmentEnd) {
                if (TypeExpression.this.myItems.size() <= 1) {
                    super.handleRecalc(psiFile, document, segmentStart, segmentEnd);
                } else {
                    JavaTemplateUtil.updateTypeBindings(this.getType(), psiFile, document, segmentStart, segmentEnd, true);
                }
            }

            @Override
            public String toString() {
                return TypeExpression.this.myItems.size() == 1 ? super.toString() : type.getPresentableText();
            }
        };
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        if (this.myItems.size() <= 1) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
        ArrayList<PsiTypeLookupItem> result = new ArrayList<PsiTypeLookupItem>(this.myItems.size());
        for (SmartTypePointer item : this.myItems) {
            PsiType type = item.getType();
            if (type == null) continue;
            result.add(PsiTypeLookupItem.createLookupItem(type, null));
        }
        return result.toArray(new LookupElement[result.size()]);
    }
}

