/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SplitIfAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.SplitIfAction");

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        boolean isOrExpression;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/SplitIfAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/SplitIfAction", "isAvailable"));
        }
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (!(token.getParent() instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)token.getParent();
        boolean isAndExpression = expression.getOperationTokenType() == JavaTokenType.ANDAND;
        boolean bl = isOrExpression = expression.getOperationTokenType() == JavaTokenType.OROR;
        if (!isAndExpression && !isOrExpression) {
            return false;
        }
        while (expression.getParent() instanceof PsiPolyadicExpression) {
            expression = (PsiPolyadicExpression)expression.getParent();
            if (isAndExpression && expression.getOperationTokenType() != JavaTokenType.ANDAND) {
                return false;
            }
            if (!isOrExpression || expression.getOperationTokenType() == JavaTokenType.OROR) continue;
            return false;
        }
        if (!(expression.getParent() instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)expression.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression, (boolean)false)) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.if.text", (Object[])new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.split.if.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/SplitIfAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/SplitIfAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/SplitIfAction", "invoke"));
        }
        try {
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiJavaToken token = (PsiJavaToken)element;
            LOG.assertTrue(token.getTokenType() == JavaTokenType.ANDAND || token.getTokenType() == JavaTokenType.OROR);
            PsiPolyadicExpression expression = (PsiPolyadicExpression)token.getParent();
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression, (boolean)false));
            if (token.getTokenType() == JavaTokenType.ANDAND) {
                SplitIfAction.doAndSplit(ifStatement, expression, token, editor);
            } else if (token.getTokenType() == JavaTokenType.OROR) {
                SplitIfAction.doOrSplit(ifStatement, expression, token, editor);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void doAndSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitIfAction.getLOperands(expression, token);
        PsiExpression rOperand = SplitIfAction.getROperands(expression, token);
        PsiManager psiManager = ifStatement.getManager();
        PsiIfStatement subIf = (PsiIfStatement)ifStatement.copy();
        subIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        if (ifStatement.getThenBranch() instanceof PsiBlockStatement) {
            PsiBlockStatement blockStmt = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText("{}", null);
            blockStmt = (PsiBlockStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)blockStmt);
            blockStmt = (PsiBlockStatement)ifStatement.getThenBranch().replace((PsiElement)blockStmt);
            blockStmt.getCodeBlock().add((PsiElement)subIf);
        } else {
            ifStatement.getThenBranch().replace((PsiElement)subIf);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static PsiExpression getROperands(PsiPolyadicExpression expression, PsiJavaToken separator) throws IncorrectOperationException {
        PsiElement next = PsiTreeUtil.skipSiblingsForward((PsiElement)separator, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
        int offsetInParent = next == null ? separator.getStartOffsetInParent() + separator.getTextLength() : next.getStartOffsetInParent();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
        String rOperands = expression.getText().substring(offsetInParent);
        return factory.createExpressionFromText(rOperands, expression.getParent());
    }

    private static PsiExpression getLOperands(PsiPolyadicExpression expression, PsiJavaToken separator) throws IncorrectOperationException {
        PsiJavaToken prev = separator;
        if (prev.getPrevSibling() instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if (prev == null) {
            throw new IncorrectOperationException("Unable to split '" + expression.getText() + "' left to '" + separator + "' (offset " + separator.getStartOffsetInParent() + ")");
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expression.getProject()).getElementFactory();
        String rOperands = expression.getText().substring(0, prev.getStartOffsetInParent());
        return factory.createExpressionFromText(rOperands, expression.getParent());
    }

    private static void doOrSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitIfAction.getLOperands(expression, token);
        PsiExpression rOperand = SplitIfAction.getROperands(expression, token);
        PsiIfStatement secondIf = (PsiIfStatement)ifStatement.copy();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
        }
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        secondIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.setElseBranch((PsiStatement)secondIf);
        if (elseBranch != null) {
            secondIf.setElseBranch(elseBranch);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }
}

