/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler");

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        LookupEx lookup;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file = InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file);
        }
        if ((lookup = LookupManager.getActiveLookup(editor)) != null) {
            lookup.showElementActions();
            return;
        }
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        if (file instanceof PsiCodeFragment) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        codeAnalyzer.autoImportReferenceAtCursor(editor, file);
        ShowIntentionsPass.IntentionsInfo intentions = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.getActionsToShow(editor, file, intentions, -1);
        if (!intentions.isEmpty()) {
            IntentionHintComponent.showIntentionHint(project, file, editor, intentions, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull IntentionAction action) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "availableFor"));
        }
        if (!file.isValid()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        boolean inProject = file.getManager().isInProject((PsiElement)file);
        return ShowIntentionActionsHandler.isAvailableHere(editor, file, element, inProject, action);
    }

    private static boolean isAvailableHere(Editor editor, PsiFile psiFile, PsiElement psiElement, boolean inProject, IntentionAction action) {
        try {
            Project project = psiFile.getProject();
            if (action instanceof PsiElementBaseIntentionAction ? !inProject || psiElement == null || !((PsiElementBaseIntentionAction)action).isAvailable(project, editor, psiElement) : !action.isAvailable(project, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @NotNull PairProcessor<PsiFile, Editor> predicate) {
        Editor injectedEditor;
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseBetweenHostAndInjected"));
        }
        Editor editorToApply = null;
        PsiFile fileToApply = null;
        int offset = hostEditor.getCaretModel().getOffset();
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, offset);
        if (injectedFile != null && predicate.process((Object)injectedFile, (Object)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
            editorToApply = injectedEditor;
            fileToApply = injectedFile;
        }
        if (editorToApply == null && predicate.process((Object)hostFile, (Object)hostEditor)) {
            editorToApply = hostEditor;
            fileToApply = hostFile;
        }
        if (editorToApply == null) {
            return null;
        }
        return Pair.create(fileToApply, editorToApply);
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, final @NotNull Editor hostEditor, final @NotNull IntentionAction action, @NotNull String text) {
        if (hostFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (hostEditor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler", "chooseActionAndInvoke"));
        }
        if (!hostFile.isValid()) {
            return false;
        }
        final Project project = hostFile.getProject();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickFix");
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, new PairProcessor<PsiFile, Editor>(){

            public boolean process(PsiFile psiFile, Editor editor) {
                return ShowIntentionActionsHandler.availableFor(psiFile, editor, action);
            }
        });
        if (pair == null) {
            return false;
        }
        final Editor editorToApply = (Editor)pair.second;
        final PsiFile fileToApply = (PsiFile)pair.first;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    action.invoke(project, editorToApply, fileToApply);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
                DaemonCodeAnalyzer.getInstance((Project)project).updateVisibleHighlighters(hostEditor);
            }
        };
        if (action.startInWriteAction()) {
            final Runnable _runnable = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(_runnable);
                }
            };
        }
        CommandProcessor.getInstance().executeCommand(project, runnable, text, null);
        return true;
    }
}

