/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.NotNull;

public class InsertLiteralUnderscoresAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "isAvailable"));
        }
        if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)element)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class, (boolean)false);
        if (literalExpression == null) {
            return false;
        }
        PsiType type = literalExpression.getType();
        if (!(PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type))) {
            return false;
        }
        String text = literalExpression.getText();
        if (text == null || text.contains("_")) {
            return false;
        }
        String converted = LiteralFormatUtil.format(text, type);
        return converted.length() != text.length();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiType type;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "invoke"));
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class, (boolean)false);
        if (literalExpression == null) {
            return;
        }
        String text = literalExpression.getText();
        String converted = LiteralFormatUtil.format(text, type = literalExpression.getType());
        if (converted.length() == text.length()) {
            return;
        }
        PsiExpression replacement = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(converted, null);
        literalExpression.replace((PsiElement)replacement);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.underscores.in.literals.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.insert.literal.underscores", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/InsertLiteralUnderscoresAction", "getText"));
        }
        return string;
    }
}

