/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindFieldsFromParametersAction
extends BaseIntentionAction
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterAction.class);
    private static final Key<Map<SmartPsiElementPointer<PsiParameter>, Boolean>> PARAMS = Key.create((String)"FIELDS_FROM_PARAMS");
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "isAvailable"));
        }
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        PsiMethod method = BindFieldsFromParametersAction.findMethod(psiParameter, editor, file);
        if (method == null) {
            return false;
        }
        List<PsiParameter> parameters = BindFieldsFromParametersAction.getAvailableParameters(method);
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> params = BindFieldsFromParametersAction.getUnboundedParams(method);
            params.clear();
            for (PsiParameter parameter : parameters) {
                params.add((SmartPsiElementPointer<PsiParameter>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)parameter));
            }
            if (params.isEmpty()) {
                return false;
            }
            if (params.size() == 1 && psiParameter != null) {
                return false;
            }
            if (psiParameter == null) {
                psiParameter = (PsiParameter)params.iterator().next().getElement();
                LOG.assertTrue(psiParameter != null);
            }
            this.setText(CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.text", (Object[])new Object[]{method.isConstructor() ? "Constructor" : "Method"}));
        }
        return BindFieldsFromParametersAction.isAvailable(psiParameter);
    }

    @Nullable
    private static PsiMethod findMethod(@Nullable PsiParameter parameter, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "findMethod"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "findMethod"));
        }
        if (parameter == null) {
            PsiElement parent;
            PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
            if (elementAt instanceof PsiIdentifier && (parent = elementAt.getParent()) instanceof PsiMethod) {
                return (PsiMethod)parent;
            }
        } else {
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiMethod) {
                return (PsiMethod)declarationScope;
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiParameter> getAvailableParameters(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getAvailableParameters"));
        }
        ArrayList<PsiParameter> parameters = new ArrayList<PsiParameter>();
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!BindFieldsFromParametersAction.isAvailable(parameter)) continue;
            parameters.add(parameter);
        }
        ArrayList<PsiParameter> arrayList = parameters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getAvailableParameters"));
        }
        return arrayList;
    }

    private static boolean isAvailable(PsiParameter psiParameter) {
        PsiClass targetClass;
        PsiType type = FieldFromParameterUtils.getSubstitutedType(psiParameter);
        return FieldFromParameterUtils.isAvailable(psiParameter, type, targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiParameter, PsiClass.class)) && psiParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> getUnboundedParams(PsiMethod psiMethod) {
        Map params = (Map)psiMethod.getUserData(PARAMS);
        if (params == null) {
            params = new ConcurrentWeakHashMap(1);
            psiMethod.putUserData(PARAMS, (Object)params);
        }
        final Map finalParams = params;
        AbstractCollection<SmartPsiElementPointer<PsiParameter>> abstractCollection = new AbstractCollection<SmartPsiElementPointer<PsiParameter>>(){

            @Override
            public boolean add(SmartPsiElementPointer<PsiParameter> psiVariable) {
                return finalParams.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<SmartPsiElementPointer<PsiParameter>> iterator() {
                return finalParams.keySet().iterator();
            }

            @Override
            public int size() {
                return finalParams.size();
            }

            @Override
            public void clear() {
                finalParams.clear();
            }
        };
        if (abstractCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getUnboundedParams"));
        }
        return abstractCollection;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "invoke"));
        }
        BindFieldsFromParametersAction.invoke(project, editor, file, !ApplicationManager.getApplication().isUnitTestMode());
    }

    private static void invoke(Project project, Editor editor, PsiFile file, boolean isInteractive) {
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiMethod method = myParameter != null ? (PsiMethod)myParameter.getDeclarationScope() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiMethod.class);
        LOG.assertTrue(method != null);
        HashSet<String> usedNames = new HashSet<String>();
        for (PsiParameter selected : BindFieldsFromParametersAction.selectParameters(project, method, BindFieldsFromParametersAction.copyUnboundedParamsAndClearOriginal(method), isInteractive)) {
            BindFieldsFromParametersAction.processParameter(project, selected, usedNames);
        }
    }

    @NotNull
    private static Iterable<PsiParameter> selectParameters(@NotNull Project project, @NotNull PsiMethod method, @NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams, boolean isInteractive) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        if (unboundedParams == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        if (unboundedParams.size() < 2 || !isInteractive) {
            List<PsiParameter> list = BindFieldsFromParametersAction.revealPointers(unboundedParams);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
            }
            return list;
        }
        ParameterClassMember[] members = BindFieldsFromParametersAction.sortByParameterIndex(BindFieldsFromParametersAction.toClassMemberArray(unboundedParams), method);
        MemberChooser<ParameterClassMember> chooser = BindFieldsFromParametersAction.showChooser(project, method, members);
        List<ParameterClassMember> selectedElements = chooser.getSelectedElements();
        if (chooser.getExitCode() != 0 || selectedElements == null) {
            List<PsiParameter> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
            }
            return list;
        }
        List<PsiParameter> list = BindFieldsFromParametersAction.revealParameterClassMembers(selectedElements);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "selectParameters"));
        }
        return list;
    }

    @NotNull
    private static MemberChooser<ParameterClassMember> showChooser(@NotNull Project project, @NotNull PsiMethod method, @NotNull ParameterClassMember[] members) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        MemberChooser chooser = new MemberChooser((ClassMember[])members, false, true, project);
        chooser.selectElements(members);
        chooser.setTitle("Choose " + (method.isConstructor() ? "Constructor" : "Method") + " Parameters");
        chooser.show();
        MemberChooser memberChooser = chooser;
        if (memberChooser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "showChooser"));
        }
        return memberChooser;
    }

    @NotNull
    private static ParameterClassMember[] sortByParameterIndex(@NotNull ParameterClassMember[] members, @NotNull PsiMethod method) {
        if (members == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "sortByParameterIndex"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "sortByParameterIndex"));
        }
        final PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(members, new Comparator<ParameterClassMember>(){

            @Override
            public int compare(ParameterClassMember o1, ParameterClassMember o2) {
                return parameterList.getParameterIndex(o1.getParameter()) - parameterList.getParameterIndex(o2.getParameter());
            }
        });
        if (members == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "sortByParameterIndex"));
        }
        return members;
    }

    @NotNull
    private static <T extends PsiElement> List<T> revealPointers(@NotNull Iterable<SmartPsiElementPointer<T>> pointers) {
        if (pointers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealPointers"));
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer<T> pointer : pointers) {
            result.add(pointer.getElement());
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealPointers"));
        }
        return arrayList;
    }

    @NotNull
    private static List<PsiParameter> revealParameterClassMembers(@NotNull Iterable<ParameterClassMember> parameterClassMembers) {
        if (parameterClassMembers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealParameterClassMembers"));
        }
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>();
        for (ParameterClassMember parameterClassMember : parameterClassMembers) {
            result.add(parameterClassMember.getParameter());
        }
        ArrayList<PsiParameter> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "revealParameterClassMembers"));
        }
        return arrayList;
    }

    @NotNull
    private static ParameterClassMember[] toClassMemberArray(@NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams) {
        if (unboundedParams == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "toClassMemberArray"));
        }
        ParameterClassMember[] result = new ParameterClassMember[unboundedParams.size()];
        int i = 0;
        for (SmartPsiElementPointer<PsiParameter> pointer : unboundedParams) {
            result[i++] = new ParameterClassMember((PsiParameter)pointer.getElement());
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "toClassMemberArray"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> copyUnboundedParamsAndClearOriginal(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "copyUnboundedParamsAndClearOriginal"));
        }
        Object object = LOCK;
        // MONITORENTER : object
        Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams = BindFieldsFromParametersAction.getUnboundedParams(method);
        ArrayList<SmartPsiElementPointer<PsiParameter>> result = new ArrayList<SmartPsiElementPointer<PsiParameter>>(unboundedParams);
        unboundedParams.clear();
        ArrayList<SmartPsiElementPointer<PsiParameter>> arrayList = result;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BindFieldsFromParametersAction", "copyUnboundedParamsAndClearOriginal"));
    }

    private static void processParameter(final Project project, final PsiParameter myParameter, Set<String> usedNames) {
        IdeDocumentHistory.getInstance(project).includeCurrentPlaceAsChangePlace();
        final PsiType type = FieldFromParameterUtils.getSubstitutedType(myParameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        final PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class);
        final PsiMethod method = (PsiMethod)myParameter.getDeclarationScope();
        final boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind, propertyName, null, type);
        String[] names = suggestedNameInfo.names;
        final boolean isFinal = !isMethodStatic && method.isConstructor();
        String name = names[0];
        if (targetClass != null) {
            for (String curName : names) {
                if (usedNames.contains(curName) || targetClass.findFieldByName(curName, false) == null) continue;
                name = curName;
                break;
            }
        }
        final String fieldName = usedNames.add(name) ? name : JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name, (PsiElement)myParameter, true);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    FieldFromParameterUtils.createFieldAndAddAssignment(project, targetClass, method, myParameter, type, fieldName, isMethodStatic, isFinal);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

