/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.hint.actions.ShowImplementationsAction;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.Nullable;

public class ShowSiblingsAction
extends ShowImplementationsAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ShowSiblingsAction.class.getName()));

    @Override
    public void performForContext(DataContext dataContext, final boolean invokedByShortcut) {
        NavigatablePsiElement[] superElements;
        PsiFile containingFile;
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (project == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final Editor editor = this.getEditor(dataContext);
        PsiElement element = ShowSiblingsAction.getElement(project, file, editor, (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext));
        if (element == null && file == null) {
            return;
        }
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : file;
        if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
            return;
        }
        if (editor != null) {
            PsiReference ref = TargetElementUtilBase.findReference(editor, editor.getCaretModel().getOffset());
            if (element == null && ref != null) {
                element = TargetElementUtilBase.getInstance().adjustReference(ref);
            }
        }
        if ((superElements = (NavigatablePsiElement[])ShowSiblingsAction.findSuperElements(element)) == null || superElements.length == 0) {
            return;
        }
        boolean isMethod = superElements[0] instanceof PsiMethod;
        JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup(superElements, "Choose super " + (isMethod ? "method" : "class or interface"), "Super " + (isMethod ? "methods" : "classes/interfaces"), isMethod ? new MethodCellRenderer(false) : new PsiClassListCellRenderer(), null, new Consumer<Object[]>(){

            public void consume(Object[] objects) {
                ShowSiblingsAction.this.showSiblings(invokedByShortcut, project, editor, file, editor != null, (PsiElement)objects[0]);
            }
        });
        if (popup != null) {
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    private void showSiblings(boolean invokedByShortcut, Project project, Editor editor, PsiFile file, boolean invokedFromEditor, PsiElement element) {
        PsiElement[] impls = ShowSiblingsAction.getSelfAndImplementations(editor, element, ShowSiblingsAction.createImplementationsSearcher(), false);
        String text = SymbolPresentationUtil.getSymbolPresentableText(element);
        this.showImplementations(impls, project, text, editor, file, element, invokedFromEditor, invokedByShortcut);
    }

    @Override
    protected boolean isIncludeAlwaysSelf() {
        return false;
    }

    @Nullable
    private static PsiElement[] findSuperElements(PsiElement element) {
        PsiNameIdentifierOwner parent = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
        if (parent == null) {
            return null;
        }
        return FindSuperElementsHelper.findSuperElements((PsiElement)parent);
    }
}

