/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import org.jetbrains.annotations.NotNull;

public class ClassDeclarationRangeHandler
implements DeclarationRangeHandler {
    @NotNull
    public TextRange getDeclarationRange(@NotNull PsiElement container) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/hint/ClassDeclarationRangeHandler", "getDeclarationRange"));
        }
        PsiClass aClass = (PsiClass)container;
        if (aClass instanceof PsiAnonymousClass) {
            PsiConstructorCall call = (PsiConstructorCall)aClass.getParent();
            int startOffset = call.getTextRange().getStartOffset();
            int endOffset = call.getArgumentList().getTextRange().getEndOffset();
            TextRange textRange = new TextRange(startOffset, endOffset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ClassDeclarationRangeHandler", "getDeclarationRange"));
            }
            return textRange;
        }
        PsiModifierList modifierList = aClass.getModifierList();
        int startOffset = modifierList == null ? aClass.getTextRange().getStartOffset() : modifierList.getTextRange().getStartOffset();
        PsiReferenceList implementsList = aClass.getImplementsList();
        int endOffset = implementsList == null ? aClass.getTextRange().getEndOffset() : implementsList.getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ClassDeclarationRangeHandler", "getDeclarationRange"));
        }
        return textRange;
    }
}

