/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightImportedElementsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiKeyword;
import org.jetbrains.annotations.Nullable;

public class HighlightImportedElementsHandlerFactory
implements HighlightUsagesHandlerFactory {
    @Override
    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(Editor editor, PsiFile file) {
        int offset = TargetElementUtilBase.adjustOffset(file, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement target = file.findElementAt(offset);
        if (!(target instanceof PsiKeyword) || !"import".equals(target.getText())) {
            return null;
        }
        PsiElement parent = target.getParent();
        if (!(parent instanceof PsiImportStatementBase)) {
            return null;
        }
        PsiElement grand = parent.getParent();
        if (!(grand instanceof PsiImportList)) {
            return null;
        }
        return new HighlightImportedElementsHandler(editor, file, target, (PsiImportStatementBase)parent);
    }
}

