/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.highlighting.HighlightExitPointsHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;

public class HighlightExitPointsHandlerFactory
implements HighlightUsagesHandlerFactory {
    @Override
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(Editor editor, PsiFile file) {
        int offset = TargetElementUtilBase.adjustOffset(file, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement target = file.findElementAt(offset);
        if (target instanceof PsiKeyword && ("return".equals(target.getText()) || "throw".equals(target.getText()))) {
            return new HighlightExitPointsHandler(editor, file, target);
        }
        return null;
    }
}

