/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.generation.CommentByLineCommentHandler;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CommentByLineCommentAction
extends BaseCodeInsightAction
implements DumbAware {
    public CommentByLineCommentAction() {
        this.setEnabledInModalContext(true);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        CommentByLineCommentHandler commentByLineCommentHandler = new CommentByLineCommentHandler();
        if (commentByLineCommentHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/actions/CommentByLineCommentAction", "getHandler"));
        }
        return commentByLineCommentHandler;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/actions/CommentByLineCommentAction", "isValidForFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/actions/CommentByLineCommentAction", "isValidForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/actions/CommentByLineCommentAction", "isValidForFile"));
        }
        FileType fileType = file.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter() != null;
        }
        return LanguageCommenters.INSTANCE.forLanguage(file.getLanguage()) != null || LanguageCommenters.INSTANCE.forLanguage(file.getViewProvider().getBaseLanguage()) != null;
    }
}

