/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateMembersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersUtil");

    private GenerateMembersUtil() {
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        PsiField field;
        PsiTypeElement typeElement;
        PsiElement element;
        if (memberPrototypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        if (memberPrototypes.isEmpty()) {
            List<T> list = memberPrototypes;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
            }
            return list;
        }
        PsiElement leaf = file.findElementAt(offset);
        if (leaf == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
            }
            return list;
        }
        PsiClass aClass = GenerateMembersUtil.findClassAtOffset(file, leaf);
        if (aClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
            }
            return list;
        }
        PsiElement anchor = ((GenerationInfo)memberPrototypes.get(0)).findInsertionAnchor(aClass, leaf);
        if (anchor instanceof PsiWhiteSpace) {
            ASTNode spaceNode = anchor.getNode();
            anchor = anchor.getNextSibling();
            assert (spaceNode != null);
            if (spaceNode.getStartOffset() <= offset && spaceNode.getStartOffset() + spaceNode.getTextLength() >= offset) {
                PsiParserFacade parserFacade;
                ASTNode singleNewLineWhitespace;
                String whiteSpace = spaceNode.getText().substring(0, offset - spaceNode.getStartOffset());
                if (!StringUtil.containsLineBreak((CharSequence)whiteSpace)) {
                    whiteSpace = whiteSpace + "\n";
                }
                if ((singleNewLineWhitespace = (parserFacade = PsiParserFacade.SERVICE.getInstance((Project)file.getProject())).createWhiteSpaceFromText(whiteSpace).getNode()) != null) {
                    spaceNode.getTreeParent().replaceChild(spaceNode, singleNewLineWhitespace);
                }
            }
        }
        for (element = anchor; !(element == null || element instanceof PsiField || element instanceof PsiMethod || element instanceof PsiClassInitializer); element = element.getNextSibling()) {
        }
        if (element instanceof PsiField && (typeElement = (field = (PsiField)element).getTypeElement()) != null && !field.equals(typeElement.getParent())) {
            field.normalizeDeclaration();
            anchor = field;
        }
        List<T> list = GenerateMembersUtil.insertMembersBeforeAnchor(aClass, anchor, memberPrototypes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersAtOffset"));
        }
        return list;
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersBeforeAnchor(PsiClass aClass, @Nullable PsiElement anchor, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        if (memberPrototypes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersBeforeAnchor"));
        }
        boolean before = true;
        for (GenerationInfo memberPrototype : memberPrototypes) {
            memberPrototype.insert(aClass, anchor, before);
            before = false;
            anchor = memberPrototype.getPsiMember();
        }
        List<T> list = memberPrototypes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insertMembersBeforeAnchor"));
        }
        return list;
    }

    public static void positionCaret(@NotNull Editor editor, @NotNull PsiElement firstMember, boolean toEditMethodBody) {
        PsiMethod method;
        PsiCodeBlock body;
        PsiMethod method2;
        PsiCodeBlock body2;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "positionCaret"));
        }
        if (firstMember == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "positionCaret"));
        }
        LOG.assertTrue(firstMember.isValid());
        Project project = firstMember.getProject();
        if (toEditMethodBody && (body2 = (method2 = (PsiMethod)firstMember).getBody()) != null) {
            CharSequence chars;
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            PsiElement l = firstBodyElement = body2.getFirstBodyElement();
            while (l instanceof PsiWhiteSpace) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body2;
            }
            PsiElement r = lastBodyElement = body2.getLastBodyElement();
            while (r instanceof PsiWhiteSpace) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body2;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            boolean adjustLineIndent = false;
            if (start > end && firstBodyElement == lastBodyElement && firstBodyElement instanceof PsiWhiteSpaceImpl && (chars = ((PsiWhiteSpaceImpl)firstBodyElement).getChars()).length() > 1 && chars.charAt(0) == '\n' && chars.charAt(1) == '\n') {
                start = end = firstBodyElement.getTextRange().getStartOffset() + 1;
                adjustLineIndent = true;
            }
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            } else if (adjustLineIndent) {
                Document document = editor.getDocument();
                RangeMarker marker = document.createRangeMarker(start, start);
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                if (marker.isValid()) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, marker.getStartOffset());
                }
            }
            return;
        }
        int offset = firstMember instanceof PsiMethod ? ((body = (method = (PsiMethod)firstMember).getBody()) == null ? method.getTextRange().getStartOffset() : body.getLBrace().getTextRange().getEndOffset()) : firstMember.getTextRange().getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public static PsiElement insert(@NotNull PsiClass aClass, @NotNull PsiMember member, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insert"));
        }
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "insert"));
        }
        if (member instanceof PsiMethod && !aClass.isInterface()) {
            PsiParameter[] parameters = ((PsiMethod)member).getParameterList().getParameters();
            boolean generateFinals = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).GENERATE_FINAL_PARAMETERS;
            for (PsiParameter parameter : parameters) {
                PsiModifierList modifierList = parameter.getModifierList();
                assert (modifierList != null);
                modifierList.setModifierProperty("final", generateFinals);
            }
        }
        if (anchor != null) {
            return before ? aClass.addBefore((PsiElement)member, anchor) : aClass.addAfter((PsiElement)member, anchor);
        }
        return aClass.add((PsiElement)member);
    }

    @Nullable
    private static PsiClass findClassAtOffset(PsiFile file, PsiElement leaf) {
        for (PsiElement element = leaf; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                PsiElement lastChild = null;
                for (PsiElement child : psiClass.getChildren()) {
                    if (child instanceof PsiJavaToken && ";".equals(child.getText())) {
                        lastChild = child;
                        break;
                    }
                    if ((!(child instanceof PsiJavaToken) || !",".equals(child.getText())) && !(child instanceof PsiEnumConstant)) continue;
                    lastChild = child;
                }
                if (lastChild != null) {
                    int adjustedOffset = lastChild.getTextRange().getEndOffset();
                    if (leaf.getTextRange().getEndOffset() <= adjustedOffset) {
                        return GenerateMembersUtil.findClassAtOffset(file, file.findElementAt(adjustedOffset));
                    }
                }
            }
            return psiClass;
        }
        return null;
    }

    public static PsiMethod substituteGenericMethod(PsiMethod method, PsiSubstitutor substitutor) {
        return GenerateMembersUtil.substituteGenericMethod(method, substitutor, null);
    }

    public static PsiMethod substituteGenericMethod(@NotNull PsiMethod sourceMethod, @NotNull PsiSubstitutor substitutor, @Nullable PsiElement target) {
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteGenericMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteGenericMethod"));
        }
        Project project = sourceMethod.getProject();
        JVMElementFactory factory = GenerateMembersUtil.getFactory(sourceMethod, target);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        try {
            PsiMethod resultMethod = GenerateMembersUtil.createMethod(factory, sourceMethod, target);
            GenerateMembersUtil.copyModifiers(sourceMethod.getModifierList(), resultMethod.getModifierList());
            PsiSubstitutor collisionResolvedSubstitutor = GenerateMembersUtil.substituteTypeParameters(factory, target, sourceMethod.getTypeParameterList(), resultMethod.getTypeParameterList(), substitutor, sourceMethod);
            GenerateMembersUtil.substituteReturnType(PsiManager.getInstance((Project)project), resultMethod, sourceMethod.getReturnType(), collisionResolvedSubstitutor);
            GenerateMembersUtil.substituteParameters(factory, codeStyleManager, sourceMethod.getParameterList(), resultMethod.getParameterList(), collisionResolvedSubstitutor, target);
            GenerateMembersUtil.copyDocComment(sourceMethod, resultMethod, factory);
            List<PsiClassType> thrownTypes = ExceptionUtil.collectSubstituted(collisionResolvedSubstitutor, sourceMethod.getThrowsList().getReferencedTypes());
            if (target instanceof PsiClass) {
                PsiClass[] supers;
                for (PsiClass aSuper : supers = ((PsiClass)target).getSupers()) {
                    PsiMethod psiMethod = aSuper.findMethodBySignature(sourceMethod, true);
                    if (psiMethod == null || psiMethod == sourceMethod) continue;
                    ExceptionUtil.retainExceptions(thrownTypes, ExceptionUtil.collectSubstituted(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aSuper, (PsiClass)((PsiClass)target), (PsiSubstitutor)PsiSubstitutor.EMPTY), psiMethod.getThrowsList().getReferencedTypes()));
                }
            }
            GenerateMembersUtil.substituteThrows(factory, resultMethod.getThrowsList(), collisionResolvedSubstitutor, sourceMethod, thrownTypes);
            return resultMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return sourceMethod;
        }
    }

    private static void copyModifiers(@NotNull PsiModifierList sourceModifierList, @NotNull PsiModifierList targetModifierList) {
        if (sourceModifierList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyModifiers"));
        }
        if (targetModifierList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyModifiers"));
        }
        VisibilityUtil.setVisibility((PsiModifierList)targetModifierList, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)sourceModifierList));
    }

    @NotNull
    private static PsiSubstitutor substituteTypeParameters(@NotNull JVMElementFactory factory, @Nullable PsiElement target, @Nullable PsiTypeParameterList sourceTypeParameterList, @Nullable PsiTypeParameterList targetTypeParameterList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        if (sourceTypeParameterList == null || targetTypeParameterList == null) {
            PsiSubstitutor psiSubstitutor = substitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
            }
            return psiSubstitutor;
        }
        HashMap substitutionMap = new HashMap(substitutor.getSubstitutionMap());
        for (PsiTypeParameter typeParam : sourceTypeParameterList.getTypeParameters()) {
            PsiTypeParameter substitutedTypeParam = GenerateMembersUtil.substituteTypeParameter(factory, typeParam, substitutor, sourceMethod);
            PsiTypeParameter resolvedTypeParam = GenerateMembersUtil.resolveTypeParametersCollision(factory, sourceTypeParameterList, target, substitutedTypeParam, substitutor);
            targetTypeParameterList.add((PsiElement)resolvedTypeParam);
            if (substitutedTypeParam == resolvedTypeParam) continue;
            substitutionMap.put(typeParam, factory.createType((PsiClass)resolvedTypeParam));
        }
        PsiSubstitutor psiSubstitutor = substitutionMap.isEmpty() ? substitutor : factory.createSubstitutor((Map)substitutionMap);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameters"));
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiTypeParameter resolveTypeParametersCollision(@NotNull JVMElementFactory factory, @NotNull PsiTypeParameterList sourceTypeParameterList, @Nullable PsiElement target, @NotNull PsiTypeParameter typeParam, @NotNull PsiSubstitutor substitutor) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        if (sourceTypeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        if (typeParam == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        for (PsiType type : substitutor.getSubstitutionMap().values()) {
            if (type == null || !Comparing.equal((String)type.getCanonicalText(), (String)typeParam.getName())) continue;
            String newName = GenerateMembersUtil.suggestUniqueTypeParameterName(typeParam.getName(), sourceTypeParameterList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class, (boolean)false));
            PsiTypeParameter newTypeParameter = factory.createTypeParameter(newName, typeParam.getSuperTypes());
            substitutor.put(typeParam, (PsiType)factory.createType((PsiClass)newTypeParameter));
            PsiTypeParameter psiTypeParameter = newTypeParameter;
            if (psiTypeParameter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
            }
            return psiTypeParameter;
        }
        PsiTypeParameter psiTypeParameter = factory.createTypeParameter(typeParam.getName(), typeParam.getSuperTypes());
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "resolveTypeParametersCollision"));
        }
        return psiTypeParameter;
    }

    @NotNull
    private static String suggestUniqueTypeParameterName(@NonNls String baseName, @NotNull PsiTypeParameterList typeParameterList, @Nullable PsiClass targetClass) {
        String newName;
        if (typeParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "suggestUniqueTypeParameterName"));
        }
        int i = 0;
        while (!GenerateMembersUtil.checkUniqueTypeParameterName(newName = baseName + ++i, typeParameterList) || targetClass != null && !GenerateMembersUtil.checkUniqueTypeParameterName(newName, targetClass.getTypeParameterList())) {
        }
        String string = newName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "suggestUniqueTypeParameterName"));
        }
        return string;
    }

    private static boolean checkUniqueTypeParameterName(@NonNls @NotNull String baseName, @Nullable PsiTypeParameterList typeParameterList) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "checkUniqueTypeParameterName"));
        }
        if (typeParameterList == null) {
            return true;
        }
        for (PsiTypeParameter typeParameter : typeParameterList.getTypeParameters()) {
            if (!Comparing.equal((String)typeParameter.getName(), (String)baseName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static PsiTypeParameter substituteTypeParameter(final @NotNull JVMElementFactory factory, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        PsiElement copy = typeParameter.copy();
        HashMap replacementMap = new HashMap();
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Map)replacementMap, substitutor, sourceMethod){
            final /* synthetic */ Map val$replacementMap;
            final /* synthetic */ PsiSubstitutor val$substitutor;
            final /* synthetic */ PsiMethod val$sourceMethod;
            {
                this.val$replacementMap = map;
                this.val$substitutor = psiSubstitutor;
                this.val$sourceMethod = psiMethod;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiTypeParameter) {
                    PsiClassType type = factory.createType((PsiClass)((PsiTypeParameter)resolve));
                    this.val$replacementMap.put(reference, factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(this.val$substitutor, (PsiType)type, (PsiTypeParameterListOwner)this.val$sourceMethod)));
                }
            }
        });
        PsiTypeParameter psiTypeParameter = (PsiTypeParameter)RefactoringUtil.replaceElementsWithMap(copy, (Map<PsiElement, PsiElement>)replacementMap);
        if (psiTypeParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteTypeParameter"));
        }
        return psiTypeParameter;
    }

    private static void substituteParameters(@NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiParameterList sourceParameterList, @NotNull PsiParameterList targetParameterList, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (codeStyleManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (sourceParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (targetParameterList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteParameters"));
        }
        PsiParameter[] parameters = sourceParameterList.getParameters();
        PsiParameter[] newParameters = GenerateMembersUtil.overriddenParameters(parameters, factory, codeStyleManager, substitutor, target);
        for (int i = 0; i < newParameters.length; ++i) {
            PsiParameter newParameter = newParameters[i];
            GenerateMembersUtil.copyOrReplaceModifierList((PsiModifierListOwner)parameters[i], (PsiModifierListOwner)newParameter);
            targetParameterList.add((PsiElement)newParameter);
        }
    }

    public static PsiParameter[] overriddenParameters(PsiParameter[] parameters, @NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "overriddenParameters"));
        }
        if (codeStyleManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "overriddenParameters"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/generation/GenerateMembersUtil", "overriddenParameters"));
        }
        PsiParameter[] result = new PsiParameter[parameters.length];
        UniqueNameGenerator generator = new UniqueNameGenerator();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType parameterType = parameter.getType();
            PsiType substituted = GenerateMembersUtil.substituteType(substitutor, parameterType, (PsiTypeParameterListOwner)((PsiMethod)parameter.getDeclarationScope()));
            String paramName = parameter.getName();
            boolean isBaseNameGenerated = true;
            boolean isSubstituted = substituted.equals(parameterType);
            if (!isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, TypeConversionUtil.erasure((PsiType)parameterType), paramName)) {
                isBaseNameGenerated = false;
            }
            if (paramName == null || isBaseNameGenerated && !isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, parameterType, paramName) || !factory.isValidParameterName(paramName)) {
                String[] names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)substituted).names;
                paramName = names.length > 0 ? generator.generateUniqueName(names[0]) : generator.generateUniqueName("p");
            } else if (!generator.value(paramName)) {
                paramName = generator.generateUniqueName(paramName);
            }
            generator.addExistingName(paramName);
            result[i] = factory.createParameter(paramName, substituted, target);
        }
        return result;
    }

    private static void substituteThrows(@NotNull JVMElementFactory factory, @NotNull PsiReferenceList targetThrowsList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod, List<PsiClassType> thrownTypes) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        if (targetThrowsList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        if (sourceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteThrows"));
        }
        for (PsiClassType thrownType : thrownTypes) {
            targetThrowsList.add(factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)thrownType, (PsiTypeParameterListOwner)sourceMethod)));
        }
    }

    private static void copyDocComment(PsiMethod source, PsiMethod target, JVMElementFactory factory) {
        PsiDocComment docComment;
        PsiElement navigationElement = source.getNavigationElement();
        if (navigationElement instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)navigationElement).getDocComment()) != null) {
            target.addAfter((PsiElement)factory.createDocCommentFromText(docComment.getText()), null);
        }
        final PsiParameter[] sourceParameters = source.getParameterList().getParameters();
        final PsiParameterList targetParameterList = target.getParameterList();
        RefactoringUtil.fixJavadocsForParams(target, new HashSet<PsiParameter>(Arrays.asList(targetParameterList.getParameters())), new Condition<Pair<PsiParameter, String>>(){

            public boolean value(Pair<PsiParameter, String> pair) {
                int parameterIndex = targetParameterList.getParameterIndex((PsiParameter)pair.first);
                if (parameterIndex >= 0 && parameterIndex < sourceParameters.length) {
                    return Comparing.strEqual((String)((String)pair.second), (String)sourceParameters[parameterIndex].getName());
                }
                return false;
            }
        });
    }

    @NotNull
    private static PsiMethod createMethod(@NotNull JVMElementFactory factory, @NotNull PsiMethod method, PsiElement target) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
        }
        if (method.isConstructor()) {
            PsiMethod psiMethod = factory.createConstructor(method.getName(), target);
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
            }
            return psiMethod;
        }
        PsiMethod psiMethod = factory.createMethod(method.getName(), (PsiType)PsiType.VOID);
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "createMethod"));
        }
        return psiMethod;
    }

    private static void substituteReturnType(@NotNull PsiManager manager, @NotNull PsiMethod method, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteReturnType"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteReturnType"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteReturnType"));
        }
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        if (returnTypeElement == null || returnType == null) {
            return;
        }
        PsiType substitutedReturnType = GenerateMembersUtil.substituteType(substitutor, returnType, (PsiTypeParameterListOwner)method);
        returnTypeElement.replace((PsiElement)new LightTypeElement(manager, substitutedReturnType instanceof PsiWildcardType ? TypeConversionUtil.erasure((PsiType)substitutedReturnType) : substitutedReturnType));
    }

    @NotNull
    private static JVMElementFactory getFactory(@NotNull PsiMethod method, @Nullable PsiElement target) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "getFactory"));
        }
        if (target == null) {
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
            if (psiElementFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "getFactory"));
            }
            return psiElementFactory;
        }
        JVMElementFactory jVMElementFactory = JVMElementFactories.getFactory((Language)target.getLanguage(), (Project)method.getProject());
        if (jVMElementFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersUtil", "getFactory"));
        }
        return jVMElementFactory;
    }

    private static boolean isBaseNameGenerated(JavaCodeStyleManager csManager, PsiType parameterType, String paramName) {
        return Arrays.asList(csManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)parameterType).names).contains(paramName);
    }

    private static PsiType substituteType(PsiSubstitutor substitutor, PsiType type, @NotNull PsiTypeParameterListOwner owner) {
        PsiType deepComponentType;
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/generation/GenerateMembersUtil", "substituteType"));
        }
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner, (PsiSubstitutor)substitutor)) {
            return TypeConversionUtil.erasure((PsiType)type);
        }
        PsiType psiType = substitutor.substitute(type);
        if (psiType != null && !((deepComponentType = psiType.getDeepComponentType()) instanceof PsiCapturedWildcardType) && !(deepComponentType instanceof PsiWildcardType)) {
            return psiType;
        }
        return TypeConversionUtil.erasure((PsiType)type);
    }

    public static boolean isChildInRange(PsiElement child, PsiElement first, PsiElement last) {
        if (child.equals(first)) {
            return true;
        }
        do {
            if (child.equals(first)) {
                return false;
            }
            if (!child.equals(last)) continue;
            return true;
        } while ((child = child.getNextSibling()) != null);
        return false;
    }

    public static void setupGeneratedMethod(PsiMethod method) {
        PsiMethod overridden;
        PsiClass base = method.getContainingClass().getSuperClass();
        PsiMethod psiMethod = overridden = base == null ? null : base.findMethodBySignature(method, true);
        if (overridden == null) {
            CreateFromUsageUtils.setupMethodBody(method, method.getContainingClass());
            return;
        }
        OverrideImplementUtil.setupMethodBody(method, overridden, method.getContainingClass());
        OverrideImplementUtil.annotateOnOverrideImplement(method, base, overridden);
    }

    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @NotNull PsiModifierListOwner targetParam) {
        if (sourceParam == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyOrReplaceModifierList"));
        }
        if (targetParam == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/generation/GenerateMembersUtil", "copyOrReplaceModifierList"));
        }
        PsiModifierList sourceModifierList = sourceParam.getModifierList();
        PsiModifierList targetModifierList = targetParam.getModifierList();
        if (sourceModifierList != null && targetModifierList != null) {
            if (sourceParam.getLanguage() == targetParam.getLanguage()) {
                targetModifierList = (PsiModifierList)targetModifierList.replace((PsiElement)sourceModifierList);
            } else {
                JVMElementFactory factory = JVMElementFactories.requireFactory((Language)targetParam.getLanguage(), (Project)targetParam.getProject());
                for (PsiAnnotation psiAnnotation : sourceModifierList.getAnnotations()) {
                    targetModifierList.add((PsiElement)factory.createAnnotationFromText(psiAnnotation.getText(), (PsiElement)sourceParam));
                }
                for (String string : PsiModifier.MODIFIERS) {
                    targetModifierList.setModifierProperty(string, sourceParam.hasModifierProperty(string));
                }
            }
            GenerateMembersUtil.processAnnotations(sourceModifierList.getProject(), targetModifierList, targetModifierList.getResolveScope());
        }
    }

    private static void processAnnotations(Project project, PsiModifierList modifierList, GlobalSearchScope moduleScope) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        HashSet<String> toRemove = new HashSet<String>();
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null) continue;
            for (OverrideImplementsAnnotationsHandler handler : (OverrideImplementsAnnotationsHandler[])Extensions.getExtensions(OverrideImplementsAnnotationsHandler.EP_NAME)) {
                String[] annotations2Remove = handler.annotationsToRemove(project, qualifiedName);
                Collections.addAll(toRemove, annotations2Remove);
                if (moduleScope == null || psiFacade.findClass(qualifiedName, moduleScope) != null) continue;
                toRemove.add(qualifiedName);
            }
        }
        for (String fqn : toRemove) {
            PsiAnnotation psiAnnotation = modifierList.findAnnotation(fqn);
            if (psiAnnotation == null) continue;
            psiAnnotation.delete();
        }
    }

    @Nullable
    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateGetterPrototype"));
        }
        return GenerateMembersUtil.annotateOnOverrideImplement(field.getContainingClass(), PropertyUtil.generateGetterPrototype((PsiField)field));
    }

    @Nullable
    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/generation/GenerateMembersUtil", "generateSetterPrototype"));
        }
        return GenerateMembersUtil.annotateOnOverrideImplement(field.getContainingClass(), PropertyUtil.generateSetterPrototype((PsiField)field));
    }

    @Nullable
    private static PsiMethod annotateOnOverrideImplement(@Nullable PsiClass targetClass, @Nullable PsiMethod generated) {
        PsiMethod superMethod;
        if (generated == null || targetClass == null) {
            return generated;
        }
        if (CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).INSERT_OVERRIDE_ANNOTATION && (superMethod = targetClass.findMethodBySignature(generated, true)) != null && superMethod.getContainingClass() != targetClass) {
            OverrideImplementUtil.annotateOnOverrideImplement(generated, targetClass, superMethod, true);
        }
        return generated;
    }
}

