/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;

public class GenerateEqualsHelper
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateEqualsHelper");
    private final PsiClass myClass;
    private final PsiField[] myEqualsFields;
    private final PsiField[] myHashCodeFields;
    private final HashSet<PsiField> myNonNullSet;
    private final PsiElementFactory myFactory;
    private String myParameterName;
    @NonNls
    private static final String BASE_OBJECT_PARAMETER_NAME = "object";
    @NonNls
    private static final String BASE_OBJECT_LOCAL_NAME = "that";
    @NonNls
    private static final String RESULT_VARIABLE = "result";
    @NonNls
    private static final String TEMP_VARIABLE = "temp";
    private String myClassInstanceName;
    @NonNls
    private static final HashMap<String, MessageFormat> PRIMITIVE_HASHCODE_FORMAT = new HashMap();
    private final boolean mySuperHasHashCode;
    private final CodeStyleManager myCodeStyleManager;
    private final JavaCodeStyleManager myJavaCodeStyleManager;
    private final Project myProject;
    private final boolean myCheckParameterWithInstanceof;
    @NonNls
    private static final MessageFormat ARRAY_COMPARER_MF = new MessageFormat("if(!java.util.Arrays.equals({1}, {0}.{1})) return false;\n");
    @NonNls
    private static final MessageFormat FIELD_COMPARER_MF = new MessageFormat("if({1}!=null ? !{1}.equals({0}.{1}) : {0}.{1}!= null)return false;\n");
    @NonNls
    private static final MessageFormat NON_NULL_FIELD_COMPARER_MF = new MessageFormat("if(!{1}.equals({0}.{1}))return false;\n");
    @NonNls
    private static final MessageFormat PRIMITIVE_FIELD_COMPARER_MF = new MessageFormat("if({1}!={0}.{1})return false;\n");
    @NonNls
    private static final MessageFormat DOUBLE_FIELD_COMPARER_MF = new MessageFormat("if({0}.compare({1}.{2}, {2}) != 0)return false;\n");

    public GenerateEqualsHelper(Project project, PsiClass aClass, PsiField[] equalsFields, PsiField[] hashCodeFields, PsiField[] nonNullFields, boolean useInstanceofToCheckParameterType) {
        this.myClass = aClass;
        this.myEqualsFields = equalsFields;
        this.myHashCodeFields = hashCodeFields;
        this.myProject = project;
        this.myCheckParameterWithInstanceof = useInstanceofToCheckParameterType;
        this.myNonNullSet = new HashSet();
        ContainerUtil.addAll(this.myNonNullSet, (Object[])nonNullFields);
        PsiManager manager = PsiManager.getInstance((Project)project);
        this.myFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        this.mySuperHasHashCode = this.superMethodExists(GenerateEqualsHelper.getHashCodeSignature());
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
    }

    private static String getUniqueLocalVarName(String base, PsiField[] fields) {
        boolean anyEqual;
        String id = base;
        int index = 0;
        block0: do {
            if (index > 0) {
                id = base + index;
            }
            ++index;
            anyEqual = false;
            for (PsiField equalsField : fields) {
                if (!id.equals(equalsField.getName())) continue;
                anyEqual = true;
                continue block0;
            }
        } while (anyEqual);
        return id;
    }

    private static boolean shouldAddOverrideAnnotation(PsiElement context) {
        CodeStyleSettings style = CodeStyleSettingsManager.getSettings((Project)context.getProject());
        return style.INSERT_OVERRIDE_ANNOTATION && PsiUtil.isLanguageLevel5OrHigher((PsiElement)context);
    }

    @Override
    public void run() {
        try {
            Collection<PsiMethod> members = this.generateMembers();
            for (PsiMethod member : members) {
                this.myClass.add((PsiElement)member);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public Collection<PsiMethod> generateMembers() throws IncorrectOperationException {
        PsiMethod equals = null;
        if (this.myEqualsFields != null && GenerateEqualsHelper.findMethod(this.myClass, GenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope())) == null) {
            equals = this.createEquals();
        }
        PsiMethod hashCode = null;
        if (this.myHashCodeFields != null && GenerateEqualsHelper.findMethod(this.myClass, GenerateEqualsHelper.getHashCodeSignature()) == null) {
            if (this.myHashCodeFields.length > 0) {
                hashCode = this.createHashCode();
            } else if (!this.mySuperHasHashCode) {
                String text = "";
                if (GenerateEqualsHelper.shouldAddOverrideAnnotation((PsiElement)this.myClass)) {
                    text = text + "@Override\n";
                }
                text = text + "public int hashCode() {\nreturn 0;\n}";
                PsiMethod trivialHashCode = this.myFactory.createMethodFromText(text, null);
                hashCode = (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)trivialHashCode);
            }
        }
        if (hashCode != null && equals != null) {
            return Arrays.asList(equals, hashCode);
        }
        if (equals != null) {
            return Collections.singletonList(equals);
        }
        if (hashCode != null) {
            return Collections.singletonList(hashCode);
        }
        return Collections.emptyList();
    }

    private PsiMethod createEquals() throws IncorrectOperationException {
        JavaCodeStyleManager codeStyleManager = this.myJavaCodeStyleManager;
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)this.myClass.getManager(), (GlobalSearchScope)this.myClass.getResolveScope());
        String[] nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)objectType).names;
        String objectBaseName = nameSuggestions.length > 0 ? nameSuggestions[0] : BASE_OBJECT_PARAMETER_NAME;
        this.myParameterName = GenerateEqualsHelper.getUniqueLocalVarName(objectBaseName, this.myEqualsFields);
        PsiClassType classType = this.myFactory.createType(this.myClass);
        nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType).names;
        String instanceBaseName = nameSuggestions.length > 0 && nameSuggestions[0].length() < 10 ? nameSuggestions[0] : BASE_OBJECT_LOCAL_NAME;
        this.myClassInstanceName = GenerateEqualsHelper.getUniqueLocalVarName(instanceBaseName, this.myEqualsFields);
        StringBuffer buffer = new StringBuffer();
        CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        if (GenerateEqualsHelper.shouldAddOverrideAnnotation((PsiElement)this.myClass)) {
            buffer.append("@Override\n");
        }
        buffer.append("public boolean equals(Object ").append(this.myParameterName).append(") {\n");
        this.addEqualsPrologue(buffer);
        if (this.myEqualsFields.length > 0) {
            this.addClassInstance(buffer);
            ArrayList equalsFields = new ArrayList();
            ContainerUtil.addAll(equalsFields, (Object[])this.myEqualsFields);
            Collections.sort(equalsFields, EqualsFieldsComparator.INSTANCE);
            for (PsiField field : equalsFields) {
                PsiClass aClass;
                if (field.hasModifierProperty("static")) continue;
                PsiType type = field.getType();
                if (type instanceof PsiArrayType) {
                    this.addArrayEquals(buffer, field);
                    continue;
                }
                if (type instanceof PsiPrimitiveType) {
                    if (PsiType.DOUBLE.equals((Object)type) || PsiType.FLOAT.equals((Object)type)) {
                        this.addDoubleFieldComparison(buffer, field);
                        continue;
                    }
                    this.addPrimitiveFieldComparison(buffer, field);
                    continue;
                }
                if (type instanceof PsiClassType && (aClass = ((PsiClassType)type).resolve()) != null && aClass.isEnum()) {
                    this.addPrimitiveFieldComparison(buffer, field);
                    continue;
                }
                this.addFieldComparison(buffer, field);
            }
        }
        buffer.append("\nreturn true;\n}");
        PsiMethod result = this.myFactory.createMethodFromText(buffer.toString(), (PsiElement)this.myClass);
        PsiParameter parameter = result.getParameterList().getParameters()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)styleSettings.GENERATE_FINAL_PARAMETERS);
        PsiMethod method = (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)result);
        method = (PsiMethod)this.myJavaCodeStyleManager.shortenClassReferences((PsiElement)method);
        return method;
    }

    private void addDoubleFieldComparison(StringBuffer buffer, PsiField field) {
        String type = PsiType.DOUBLE.equals((Object)field.getType()) ? "Double" : "Float";
        Object[] parameters = new Object[]{type, this.myClassInstanceName, field.getName()};
        DOUBLE_FIELD_COMPARER_MF.format(parameters, buffer, (FieldPosition)null);
    }

    private void addArrayEquals(StringBuffer buffer, PsiField field) {
        PsiType fieldType = field.getType();
        if (GenerateEqualsHelper.isNestedArray(fieldType)) {
            buffer.append(" ");
            buffer.append(CodeInsightBundle.message((String)"generate.equals.compare.nested.arrays.comment", (Object[])new Object[]{field.getName()}));
            buffer.append("\n");
            return;
        }
        if (GenerateEqualsHelper.isArrayOfObjects(fieldType)) {
            buffer.append(" ");
            buffer.append(CodeInsightBundle.message((String)"generate.equals.compare.arrays.comment", (Object[])new Object[0]));
            buffer.append("\n");
        }
        ARRAY_COMPARER_MF.format(this.getComparerFormatParameters(field), buffer, (FieldPosition)null);
    }

    private Object[] getComparerFormatParameters(PsiField field) {
        return new Object[]{this.myClassInstanceName, field.getName()};
    }

    private void addFieldComparison(StringBuffer buffer, PsiField field) {
        boolean canBeNull;
        boolean bl = canBeNull = !this.myNonNullSet.contains(field);
        if (canBeNull) {
            FIELD_COMPARER_MF.format(this.getComparerFormatParameters(field), buffer, (FieldPosition)null);
        } else {
            NON_NULL_FIELD_COMPARER_MF.format(this.getComparerFormatParameters(field), buffer, (FieldPosition)null);
        }
    }

    private void addPrimitiveFieldComparison(StringBuffer buffer, PsiField field) {
        PRIMITIVE_FIELD_COMPARER_MF.format(this.getComparerFormatParameters(field), buffer, (FieldPosition)null);
    }

    private void addInstanceOfToText(@NonNls StringBuffer buffer, String returnValue) {
        if (this.myCheckParameterWithInstanceof) {
            buffer.append("if(!(").append(this.myParameterName).append(" instanceof ").append(this.myClass.getName()).append(")) return ").append(returnValue).append(";\n");
        } else {
            buffer.append("if(").append(this.myParameterName).append("== null || getClass() != ").append(this.myParameterName).append(".getClass()) return ").append(returnValue).append(";\n");
        }
    }

    private void addEqualsPrologue(@NonNls StringBuffer buffer) {
        buffer.append("if(this==");
        buffer.append(this.myParameterName);
        buffer.append(") return true;\n");
        if (!this.superMethodExists(GenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope()))) {
            this.addInstanceOfToText(buffer, Boolean.toString(false));
        } else {
            this.addInstanceOfToText(buffer, Boolean.toString(false));
            buffer.append("if(!super.equals(");
            buffer.append(this.myParameterName);
            buffer.append(")) return false;\n");
        }
    }

    private void addClassInstance(@NonNls StringBuffer buffer) {
        buffer.append("\n");
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myCodeStyleManager.getProject());
        if (settings.GENERATE_FINAL_LOCALS) {
            buffer.append("final ");
        }
        buffer.append(this.myClass.getName());
        buffer.append(" ").append(this.myClassInstanceName).append(" = (");
        buffer.append(this.myClass.getName());
        buffer.append(")");
        buffer.append(this.myParameterName);
        buffer.append(";\n\n");
    }

    private boolean superMethodExists(MethodSignature methodSignature) {
        LOG.assertTrue(this.myClass.isValid());
        PsiMethod superEquals = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)methodSignature, (boolean)true);
        if (superEquals == null) {
            return true;
        }
        if (superEquals.hasModifierProperty("abstract")) {
            return false;
        }
        return !"java.lang.Object".equals(superEquals.getContainingClass().getQualifiedName());
    }

    private PsiMethod createHashCode() throws IncorrectOperationException {
        StringBuilder buffer = new StringBuilder();
        if (GenerateEqualsHelper.shouldAddOverrideAnnotation((PsiElement)this.myClass)) {
            buffer.append("@Override\n");
        }
        buffer.append("public int hashCode() {\n");
        if (!this.mySuperHasHashCode && this.myHashCodeFields.length == 1) {
            PsiField field = this.myHashCodeFields[0];
            String tempName = this.addTempForOneField(field, buffer);
            buffer.append("return ");
            if (field.getType() instanceof PsiPrimitiveType) {
                GenerateEqualsHelper.addPrimitiveFieldHashCode(buffer, field, tempName);
            } else {
                this.addFieldHashCode(buffer, field, false);
            }
            buffer.append(";\n}");
        } else if (this.myHashCodeFields.length > 0) {
            String tempName;
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myCodeStyleManager.getProject());
            String resultName = GenerateEqualsHelper.getUniqueLocalVarName(settings.LOCAL_VARIABLE_NAME_PREFIX + RESULT_VARIABLE, this.myHashCodeFields);
            buffer.append("int ");
            buffer.append(resultName);
            boolean resultAssigned = false;
            boolean resultDeclarationCompleted = false;
            if (this.mySuperHasHashCode) {
                buffer.append(" = ");
                this.addSuperHashCode(buffer);
                buffer.append(";\n");
                resultAssigned = true;
                resultDeclarationCompleted = true;
            }
            if ((tempName = this.addTempDeclaration(buffer, resultDeclarationCompleted)) != null) {
                resultDeclarationCompleted = true;
            }
            for (PsiField field : this.myHashCodeFields) {
                GenerateEqualsHelper.addTempAssignment(field, buffer, tempName);
                if (resultDeclarationCompleted) {
                    buffer.append(resultName);
                }
                buffer.append(" = ");
                if (resultAssigned) {
                    buffer.append("31*");
                    buffer.append(resultName);
                    buffer.append(" + ");
                }
                if (field.getType() instanceof PsiPrimitiveType) {
                    GenerateEqualsHelper.addPrimitiveFieldHashCode(buffer, field, tempName);
                } else {
                    this.addFieldHashCode(buffer, field, resultAssigned);
                }
                buffer.append(";\n");
                resultAssigned = true;
                resultDeclarationCompleted = true;
            }
            buffer.append("return ");
            buffer.append(resultName);
            buffer.append(";\n}");
        } else {
            buffer.append("return 0;\n}");
        }
        PsiMethod hashCode = this.myFactory.createMethodFromText(buffer.toString(), null);
        hashCode = (PsiMethod)this.myJavaCodeStyleManager.shortenClassReferences((PsiElement)hashCode);
        return (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)hashCode);
    }

    private static void addTempAssignment(PsiField field, StringBuilder buffer, String tempName) {
        if (PsiType.DOUBLE.equals((Object)field.getType())) {
            buffer.append(tempName);
            GenerateEqualsHelper.addTempForDoubleInitialization(field, buffer);
        }
    }

    private static void addTempForDoubleInitialization(PsiField field, @NonNls StringBuilder buffer) {
        buffer.append(" = ");
        buffer.append("Double.doubleToLongBits(");
        buffer.append(field.getName());
        buffer.append(");\n");
    }

    private String addTempDeclaration(@NonNls StringBuilder buffer, boolean resultDeclarationCompleted) {
        for (PsiField hashCodeField : this.myHashCodeFields) {
            if (!PsiType.DOUBLE.equals((Object)hashCodeField.getType())) continue;
            String name = GenerateEqualsHelper.getUniqueLocalVarName(TEMP_VARIABLE, this.myHashCodeFields);
            if (!resultDeclarationCompleted) {
                buffer.append("\n;");
            }
            buffer.append("long ");
            buffer.append(name);
            buffer.append(";\n");
            return name;
        }
        return null;
    }

    private String addTempForOneField(PsiField field, StringBuilder buffer) {
        if (PsiType.DOUBLE.equals((Object)field.getType())) {
            String name = GenerateEqualsHelper.getUniqueLocalVarName(TEMP_VARIABLE, this.myHashCodeFields);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myCodeStyleManager.getProject());
            if (settings.GENERATE_FINAL_LOCALS) {
                buffer.append("final ");
            }
            buffer.append("long ").append(name);
            GenerateEqualsHelper.addTempForDoubleInitialization(field, buffer);
            return name;
        }
        return null;
    }

    private static void addPrimitiveFieldHashCode(StringBuilder buffer, PsiField field, String tempName) {
        MessageFormat format = (MessageFormat)PRIMITIVE_HASHCODE_FORMAT.get((Object)field.getType().getCanonicalText());
        buffer.append(format.format(new Object[]{field.getName(), tempName}));
    }

    private void addFieldHashCode(@NonNls StringBuilder buffer, PsiField field, boolean brace) {
        String name = field.getName();
        if (this.myNonNullSet.contains(field)) {
            GenerateEqualsHelper.adjustHashCodeToArrays(buffer, field, name);
        } else {
            if (brace) {
                buffer.append("(");
            }
            buffer.append(name);
            buffer.append(" != null ? ");
            GenerateEqualsHelper.adjustHashCodeToArrays(buffer, field, name);
            buffer.append(" : 0");
            if (brace) {
                buffer.append(")");
            }
        }
    }

    private static void adjustHashCodeToArrays(@NonNls StringBuilder buffer, PsiField field, String name) {
        if (field.getType() instanceof PsiArrayType && GenerateEqualsHelper.hasArraysHashCode(field)) {
            buffer.append("java.util.Arrays.hashCode(");
            buffer.append(name);
            buffer.append(")");
        } else {
            buffer.append(name);
            buffer.append(".hashCode()");
        }
    }

    private static boolean hasArraysHashCode(PsiField field) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)field);
        if (module == null) {
            return false;
        }
        PsiClass arraysClass = JavaPsiFacade.getInstance((Project)field.getProject()).findClass("java.util.Arrays", module.getModuleWithLibrariesScope());
        if (arraysClass == null) {
            return false;
        }
        PsiMethod[] methods = arraysClass.findMethodsByName("hashCode", false);
        return methods.length > 0;
    }

    private void addSuperHashCode(StringBuilder buffer) {
        if (this.mySuperHasHashCode) {
            buffer.append("super.hashCode()");
        } else {
            buffer.append("0");
        }
    }

    public void invoke() {
        ApplicationManager.getApplication().runWriteAction((Runnable)this);
    }

    static PsiMethod findMethod(PsiClass aClass, MethodSignature signature) {
        return MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false);
    }

    private static void initPrimitiveHashcodeFormats() {
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"byte", (Object)new MessageFormat("(int) {0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"short", (Object)new MessageFormat("(int) {0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"int", (Object)new MessageFormat("{0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"long", (Object)new MessageFormat("(int) ({0} ^ ({0} >>> 32))"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"boolean", (Object)new MessageFormat("({0} ? 1 : 0)"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"float", (Object)new MessageFormat("({0} != +0.0f ? Float.floatToIntBits({0}) : 0)"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"double", (Object)new MessageFormat("(int) ({1} ^ ({1} >>> 32))"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"char", (Object)new MessageFormat("(int) {0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"void", (Object)new MessageFormat("0"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"void", (Object)new MessageFormat("({0} ? 1 : 0)"));
    }

    public static boolean isNestedArray(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        return componentType instanceof PsiArrayType;
    }

    public static boolean isArrayOfObjects(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
        if (psiClass == null) {
            return false;
        }
        String qName = psiClass.getQualifiedName();
        return "java.lang.Object".equals(qName);
    }

    public static MethodSignature getHashCodeSignature() {
        return MethodSignatureUtil.createMethodSignature((String)"hashCode", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    public static MethodSignature getEqualsSignature(Project project, GlobalSearchScope scope) {
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)scope);
        return MethodSignatureUtil.createMethodSignature((String)"equals", (PsiType[])new PsiType[]{javaLangObject}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    static {
        GenerateEqualsHelper.initPrimitiveHashcodeFormats();
    }

    static class EqualsFieldsComparator
    implements Comparator<PsiField> {
        public static final EqualsFieldsComparator INSTANCE = new EqualsFieldsComparator();

        EqualsFieldsComparator() {
        }

        @Override
        public int compare(PsiField f1, PsiField f2) {
            if (f1.getType() instanceof PsiPrimitiveType && !(f2.getType() instanceof PsiPrimitiveType)) {
                return -1;
            }
            if (!(f1.getType() instanceof PsiPrimitiveType) && f2.getType() instanceof PsiPrimitiveType) {
                return 1;
            }
            String name1 = f1.getName();
            String name2 = f2.getName();
            assert (name1 != null && name2 != null);
            return name1.compareTo(name2);
        }
    }
}

