/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingPolicy;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class UpdateFoldRegionsOperation
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)("#" + UpdateFoldRegionsOperation.class.getName()));
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final boolean myApplyDefaultState;
    private final FoldingUpdate.FoldingMap myElementsToFoldMap;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FoldingUpdate.FoldingMap elementsToFoldMap, boolean applyDefaultState, boolean forInjected) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        if (elementsToFoldMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "<init>"));
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file;
        this.myApplyDefaultState = applyDefaultState;
        this.myElementsToFoldMap = elementsToFoldMap;
        this.myForInjected = forInjected;
    }

    @Override
    public void run() {
        EditorFoldingInfo info = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        THashMap rangeToExpandStatusMap = ContainerUtil.newTroveMap();
        this.removeInvalidRegions(info, foldingModel, (Map<TextRange, Boolean>)rangeToExpandStatusMap);
        THashMap shouldExpand = ContainerUtil.newTroveMap();
        THashMap groupExpand = ContainerUtil.newTroveMap();
        List<FoldRegion> newRegions = this.addNewRegions(info, foldingModel, (Map<TextRange, Boolean>)rangeToExpandStatusMap, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
    }

    private static void applyExpandStatus(@NotNull List<FoldRegion> newRegions, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (newRegions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "applyExpandStatus"));
        }
        if (shouldExpand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "applyExpandStatus"));
        }
        if (groupExpand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "applyExpandStatus"));
        }
        for (FoldRegion region : newRegions) {
            FoldingGroup group = region.getGroup();
            Boolean expanded = group == null ? shouldExpand.get(region) : groupExpand.get(group);
            if (expanded == null) continue;
            region.setExpanded(expanded.booleanValue());
        }
    }

    private List<FoldRegion> addNewRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (foldingModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (rangeToExpandStatusMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (shouldExpand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        if (groupExpand == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "addNewRegions"));
        }
        ArrayList newRegions = ContainerUtil.newArrayList();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        for (PsiElement element : this.myElementsToFoldMap.keySet()) {
            ProgressManager.checkCanceled();
            Collection descriptors = this.myElementsToFoldMap.get(element);
            for (FoldingDescriptor descriptor : descriptors) {
                boolean expandStatus;
                FoldingGroup group = descriptor.getGroup();
                TextRange range = descriptor.getRange();
                String placeholder = descriptor.getPlaceholderText();
                if (range.getEndOffset() > this.myEditor.getDocument().getTextLength()) {
                    LOG.error(String.format("Invalid folding descriptor detected (%s). It ends beyond the document range (%d)", descriptor, this.myEditor.getDocument().getTextLength()));
                    continue;
                }
                FoldRegion region = foldingModel.createFoldRegion(range.getStartOffset(), range.getEndOffset(), placeholder == null ? "..." : placeholder, group, descriptor.isNonExpandable());
                if (region == null) continue;
                PsiElement psi = descriptor.getElement().getPsi();
                if (!(psi != null && psi.isValid() && foldingModel.addFoldRegion(region) && this.myFile.isValid())) {
                    region.dispose();
                    continue;
                }
                info.addRegion(region, smartPointerManager.createSmartPsiElementPointer(psi, this.myFile));
                newRegions.add(region);
                boolean bl = expandStatus = !descriptor.isNonExpandable() && this.shouldExpandNewRegion(element, range, rangeToExpandStatusMap);
                if (group == null) {
                    shouldExpand.put(region, expandStatus);
                    continue;
                }
                Boolean alreadyExpanded = groupExpand.get(group);
                groupExpand.put(group, alreadyExpanded == null ? expandStatus : alreadyExpanded != false || expandStatus);
            }
        }
        return newRegions;
    }

    private boolean shouldExpandNewRegion(PsiElement element, TextRange range, Map<TextRange, Boolean> rangeToExpandStatusMap) {
        if (this.myApplyDefaultState) {
            return !FoldingPolicy.isCollapseByDefault(element);
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range);
        return oldStatus == null || FoldingUtil.caretInsideRange(this.myEditor, range) || oldStatus != false;
    }

    private void removeInvalidRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "removeInvalidRegions"));
        }
        if (foldingModel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "removeInvalidRegions"));
        }
        if (rangeToExpandStatusMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation", "removeInvalidRegions"));
        }
        ArrayList toRemove = ContainerUtil.newArrayList();
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        for (FoldRegion region : foldingModel.getAllFoldRegions()) {
            Collection descriptors;
            PsiFile containingFile;
            boolean isInjected;
            PsiElement element = info.getPsiElement(region);
            if (element != null && (isInjected = injectedManager.isInjectedFragment(containingFile = element.getContainingFile())) != this.myForInjected) continue;
            if (element != null && !(descriptors = this.myElementsToFoldMap.get(element)).isEmpty()) {
                FoldingDescriptor[] array;
                boolean matchingDescriptorFound = false;
                for (FoldingDescriptor descriptor : array = descriptors.toArray(new FoldingDescriptor[descriptors.size()])) {
                    TextRange range = descriptor.getRange();
                    if (!TextRange.areSegmentsEqual((Segment)region, (Segment)range)) continue;
                    matchingDescriptorFound = true;
                    if (!region.isValid() || region.getGroup() != null || descriptor.getGroup() != null || !region.getPlaceholderText().equals(descriptor.getPlaceholderText()) || range.getLength() < 2) {
                        rangeToExpandStatusMap.put(range, region.isExpanded());
                        toRemove.add(region);
                        break;
                    }
                    this.myElementsToFoldMap.remove(element, descriptor);
                }
                if (matchingDescriptorFound) continue;
                for (FoldingDescriptor descriptor : descriptors) {
                    rangeToExpandStatusMap.put(descriptor.getRange(), region.isExpanded());
                }
                toRemove.add(region);
                continue;
            }
            if (region.isValid() && info.isLightRegion(region)) {
                boolean isExpanded = region.isExpanded();
                rangeToExpandStatusMap.put(TextRange.create((Segment)region), isExpanded ? Boolean.TRUE : Boolean.FALSE);
                continue;
            }
            toRemove.add(region);
        }
        for (FoldRegion region : toRemove) {
            foldingModel.removeFoldRegion(region);
            info.removeRegion(region);
        }
    }
}

