/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.jetbrains.annotations.Nullable;

public class JavaFoldingBuilder
extends JavaFoldingBuilderBase {
    @Override
    protected boolean isBelowRightMargin(Project project, int lineLength) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project);
        return lineLength <= settings.RIGHT_MARGIN;
    }

    @Override
    protected boolean shouldShowExplicitLambdaType(PsiAnonymousClass anonymousClass, PsiNewExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReferenceExpression || parent instanceof PsiAssignmentExpression) {
            return true;
        }
        ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expression, false);
        return types.length != 1 || !types[0].getType().equals(anonymousClass.getBaseClassType());
    }

    @Override
    @Nullable
    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof SyntheticElement) {
            return null;
        }
        return super.getRangeToFold(element);
    }
}

