/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUtil {
    private FoldingUtil() {
    }

    @Nullable
    public static FoldRegion findFoldRegion(Editor editor, int startOffset, int endOffset) {
        FoldRegion[] foldRegions;
        for (FoldRegion region : foldRegions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid() || region.getStartOffset() != startOffset || region.getEndOffset() != endOffset) continue;
            return region;
        }
        return null;
    }

    @Nullable
    public static FoldRegion findFoldRegionStartingAtLine(@NotNull Editor editor, int line) {
        FoldRegion[] regions;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/folding/impl/FoldingUtil", "findFoldRegionStartingAtLine"));
        }
        FoldRegion result = null;
        if (line < 0 || line >= editor.getDocument().getLineCount()) {
            return result;
        }
        for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid() || region.getDocument().getLineNumber(region.getStartOffset()) != line) continue;
            if (result != null) {
                return null;
            }
            result = region;
        }
        return result;
    }

    public static FoldRegion[] getFoldRegionsAtOffset(Editor editor, int offset) {
        FoldRegion[] allRegions;
        ArrayList<FoldRegion> list = new ArrayList<FoldRegion>();
        for (FoldRegion region : allRegions = editor.getFoldingModel().getAllFoldRegions()) {
            if (region.getStartOffset() > offset || offset > region.getEndOffset()) continue;
            list.add(region);
        }
        FoldRegion[] regions = list.toArray(new FoldRegion[list.size()]);
        Arrays.sort(regions, Collections.reverseOrder(RangeMarker.BY_START_OFFSET));
        return regions;
    }

    public static boolean caretInsideRange(Editor editor, TextRange range) {
        int offset = editor.getCaretModel().getOffset();
        return range.contains(offset) && range.getStartOffset() != offset;
    }
}

