/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SmartEnterAction
extends EditorAction {
    public SmartEnterAction() {
        super((EditorActionHandler)new Handler());
    }

    protected Editor getEditor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/smartEnter/SmartEnterAction", "getEditor"));
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Project project = editor.getProject();
        if (project == null) {
            project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        }
        return project == null ? null : BaseCodeInsightAction.getInjectedEditor(project, editor);
    }

    public static void plainEnter(Editor editor, DataContext dataContext) {
        SmartEnterAction.getEnterHandler().execute(editor, dataContext);
    }

    private static EditorActionHandler getEnterHandler() {
        return EditorActionManager.getInstance().getActionHandler("EditorStartNewLine");
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public Handler() {
            super(true);
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            return SmartEnterAction.getEnterHandler().isEnabled(editor, dataContext);
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            List processors;
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null || editor.isOneLineMode()) {
                SmartEnterAction.plainEnter(editor, dataContext);
                return;
            }
            LookupManager.getInstance(project).hideActiveLookup();
            int caretOffset = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            if (psiFile == null) {
                SmartEnterAction.plainEnter(editor, dataContext);
                return;
            }
            if (EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace(editor, caretOffset, psiFile.getFileType())) {
                EditorActionHandler enterHandler = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                enterHandler.execute(editor, dataContext);
                return;
            }
            Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project);
            boolean processed = false;
            if (language != null && !(processors = SmartEnterProcessors.INSTANCE.allForLanguage(language)).isEmpty()) {
                for (SmartEnterProcessor processor : processors) {
                    if (!processor.process(project, editor, psiFile)) continue;
                    processed = true;
                    break;
                }
            }
            if (!processed) {
                SmartEnterAction.plainEnter(editor, dataContext);
            }
        }
    }
}

