/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class EnterBetweenBracesHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (caretOffsetRef == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/editorActions/enter/EnterBetweenBracesHandler", "preprocessEnter"));
        }
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int caretOffset = (Integer)caretOffsetRef.get();
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (caretOffset <= 0 || caretOffset >= text.length() || !this.isBracePair(text.charAt(caretOffset - 1), text.charAt(caretOffset)) || file.findElementAt(caretOffset) == file.findElementAt(caretOffset - 1)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int line = document.getLineNumber(caretOffset);
        int start = document.getLineStartOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file, text, caretOffset, start);
        String indentInsideJavadoc = commentContext.docAsterisk ? CodeDocumentationUtil.getIndentInsideJavadoc(document, caretOffset) : null;
        originalHandler.execute(editor, dataContext);
        Project project = editor.getProject();
        if (indentInsideJavadoc != null && project != null && CodeStyleSettingsManager.getSettings((Project)project).JD_LEADING_ASTERISKS_ARE_ENABLED) {
            document.insertString(editor.getCaretModel().getOffset(), (CharSequence)("*" + indentInsideJavadoc));
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
        try {
            CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent(file, editor.getCaretModel().getOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return indentInsideJavadoc == null ? EnterHandlerDelegate.Result.Continue : EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    protected boolean isBracePair(char c1, char c2) {
        return c1 == '(' && c2 == ')' || c1 == '{' && c2 == '}';
    }
}

