/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class SelectionQuotingTypedHandler
extends TypedHandlerDelegate {
    public static final ExtensionPointName<DequotingFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionDequotingFilter");
    private boolean myRestoreStickySelection;
    private static final Key<String> REPLACEMENT_TEXT = Key.create((String)"SelectionQuotingTypedHandler.replacementText");
    private static final Key<TextRange> REPLACED_TEXT_RANGE = Key.create((String)"SelectionQuotingTypedHandler.replacedTextRange");
    private static final Key<Boolean> LTR_SELECTION = Key.create((String)"SelectionQuotingTypedHandler.ltrSelection");

    public TypedHandlerDelegate.Result checkAutoPopup(final char c, Project project, final Editor editor, final PsiFile psiFile) {
        if (CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && editor.getSelectionModel().hasSelection(true) && SelectionQuotingTypedHandler.isDelimiter(c)) {
            this.myRestoreStickySelection = editor instanceof EditorEx && ((EditorEx)editor).isStickySelection();
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    String replacementText = null;
                    String selectedText = caret.getSelectedText();
                    if (!StringUtil.isEmpty((String)selectedText)) {
                        if (selectedText.length() > 1) {
                            char firstChar = selectedText.charAt(0);
                            char lastChar = selectedText.charAt(selectedText.length() - 1);
                            if (SelectionQuotingTypedHandler.isSimilarDelimiters(firstChar, c) && lastChar == SelectionQuotingTypedHandler.getMatchingDelimiter(firstChar) && (SelectionQuotingTypedHandler.isQuote(firstChar) || firstChar != c) && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(psiFile, editor, selectedText, c) && selectedText.indexOf(lastChar, 1) == selectedText.length() - 1) {
                                selectedText = selectedText.substring(1, selectedText.length() - 1);
                            }
                        }
                        char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
                        replacementText = String.valueOf(c) + selectedText + c2;
                    }
                    caret.putUserData(REPLACEMENT_TEXT, replacementText);
                }
            });
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    String replacementText = (String)caret.getUserData(REPLACEMENT_TEXT);
                    caret.putUserData(REPLACEMENT_TEXT, null);
                    if (replacementText == null) {
                        caret.putUserData(LTR_SELECTION, null);
                        caret.putUserData(REPLACED_TEXT_RANGE, null);
                    } else {
                        int selectionStart = caret.getSelectionStart();
                        int selectionEnd = caret.getSelectionEnd();
                        caret.putUserData(LTR_SELECTION, (Object)(caret.getLeadSelectionOffset() != selectionEnd ? 1 : 0));
                        caret.putUserData(REPLACED_TEXT_RANGE, (Object)(Registry.is((String)"editor.smarterSelectionQuoting") ? new TextRange(selectionStart + 1, selectionStart + replacementText.length() - 1) : new TextRange(selectionStart, selectionStart + replacementText.length())));
                        caret.removeSelection();
                        editor.getDocument().replaceString(selectionStart, selectionEnd, (CharSequence)replacementText);
                    }
                }
            });
            return TypedHandlerDelegate.Result.STOP;
        }
        return super.checkAutoPopup(c, project, editor, psiFile);
    }

    private static boolean shouldSkipReplacementOfQuotesOrBraces(PsiFile psiFile, Editor editor, String selectedText, char c) {
        for (DequotingFilter filter : (DequotingFilter[])Extensions.getExtensions(EP_NAME)) {
            if (!filter.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c)) continue;
            return true;
        }
        return false;
    }

    private static char getMatchingDelimiter(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        if (c == '<') {
            return '>';
        }
        return c;
    }

    private static boolean isDelimiter(char c) {
        return SelectionQuotingTypedHandler.isBracket(c) || SelectionQuotingTypedHandler.isQuote(c);
    }

    private static boolean isBracket(char c) {
        return c == '(' || c == '{' || c == '[' || c == '<';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    private static boolean isSimilarDelimiters(char c1, char c2) {
        return SelectionQuotingTypedHandler.isBracket(c1) && SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c1) && SelectionQuotingTypedHandler.isQuote(c2);
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char charTyped, Project project, final Editor editor, PsiFile file, FileType fileType) {
        final Ref caretUpdated = new Ref((Object)Boolean.FALSE);
        editor.getCaretModel().runForEachCaret(new CaretAction(){

            public void perform(Caret caret) {
                TextRange replacedTextRange = (TextRange)caret.getUserData(REPLACED_TEXT_RANGE);
                caret.putUserData(REPLACED_TEXT_RANGE, null);
                if (replacedTextRange != null) {
                    boolean ltrSelection;
                    Boolean ltrSelectionBoxed = (Boolean)caret.getUserData(LTR_SELECTION);
                    caret.putUserData(LTR_SELECTION, null);
                    boolean bl = ltrSelection = ltrSelectionBoxed == null ? false : ltrSelectionBoxed;
                    if (replacedTextRange.getEndOffset() <= editor.getDocument().getTextLength()) {
                        if (SelectionQuotingTypedHandler.this.myRestoreStickySelection && editor instanceof EditorEx) {
                            EditorEx editorEx = (EditorEx)editor;
                            editorEx.setStickySelection(false);
                            caret.moveToOffset(ltrSelection ? replacedTextRange.getStartOffset() : replacedTextRange.getEndOffset());
                            editorEx.setStickySelection(true);
                            caret.moveToOffset(ltrSelection ? replacedTextRange.getEndOffset() : replacedTextRange.getStartOffset());
                        } else {
                            if (ltrSelection || editor instanceof EditorWindow) {
                                caret.setSelection(replacedTextRange.getStartOffset(), replacedTextRange.getEndOffset());
                            } else {
                                caret.setSelection(replacedTextRange.getEndOffset(), replacedTextRange.getStartOffset());
                            }
                            if (Registry.is((String)"editor.smarterSelectionQuoting")) {
                                caret.moveToOffset(ltrSelection ? replacedTextRange.getEndOffset() : replacedTextRange.getStartOffset());
                            }
                        }
                    }
                    caretUpdated.set((Object)Boolean.TRUE);
                }
            }
        });
        return (Boolean)caretUpdated.get() != false ? TypedHandlerDelegate.Result.STOP : TypedHandlerDelegate.Result.CONTINUE;
    }

    public static abstract class DequotingFilter {
        public abstract boolean skipReplacementQuotesOrBraces(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull String var3, char var4);
    }
}

