/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Producer;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PasteHandler
extends EditorActionHandler
implements EditorTextInsertHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.PasteHandler");
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.customPasteProvider");
    private final EditorActionHandler myOriginalHandler;

    public PasteHandler(EditorActionHandler originalAction) {
        this.myOriginalHandler = originalAction;
    }

    public void execute(Editor editor, DataContext dataContext) {
        this.execute(editor, dataContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Editor editor, final DataContext dataContext, final @Nullable Producer<Transferable> producer) {
        Project project;
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        Document document = editor.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, (Project)CommonDataKeys.PROJECT.getData(dataContext))) {
            return;
        }
        DataContext context = dataContext;
        if (producer != null) {
            context = new DataContext(){

                public Object getData(@NonNls String dataId) {
                    return PasteAction.TRANSFERABLE_PROVIDER.is(dataId) ? producer : dataContext.getData(dataId);
                }
            };
        }
        if ((project = editor.getProject()) == null || editor.isColumnMode() || editor.getSelectionModel().hasBlockSelection() || editor.getCaretModel().getCaretCount() > 1) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, context);
            }
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, context);
            }
            return;
        }
        document.startGuardedBlockChecking();
        try {
            for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions(EP_NAME)) {
                if (!provider.isPasteEnabled(context)) continue;
                provider.performPaste(context);
                return;
            }
            PasteHandler.doPaste(editor, project, file, document, producer);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
        }
    }

    private static void doPaste(final Editor editor, final Project project, PsiFile file, Document document, Producer<Transferable> producer) {
        Transferable content = null;
        if (producer != null) {
            content = (Transferable)producer.produce();
        } else {
            CopyPasteManager manager = CopyPasteManager.getInstance();
            if (manager.areDataFlavorsAvailable(new DataFlavor[]{DataFlavor.stringFlavor}) && (content = manager.getContents()) != null) {
                manager.stopKillRings();
            }
        }
        if (content != null) {
            String text = null;
            try {
                text = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                editor.getComponent().getToolkit().beep();
            }
            if (text == null) {
                return;
            }
            CodeInsightSettings settings = CodeInsightSettings.getInstance();
            HashMap extraData = new HashMap();
            for (CopyPastePostProcessor processor : (CopyPastePostProcessor[])Extensions.getExtensions(CopyPastePostProcessor.EP_NAME)) {
                Object data = processor.extractTransferableData(content);
                if (data == null) continue;
                extraData.put(processor, data);
            }
            text = TextBlockTransferable.convertLineSeparators(text, "\n", extraData.values());
            CaretModel caretModel = editor.getCaretModel();
            SelectionModel selectionModel = editor.getSelectionModel();
            int col = caretModel.getLogicalPosition().column;
            int caretOffset = caretModel.getOffset();
            final int blockIndentAnchorColumn = selectionModel.hasSelection() && caretOffset >= selectionModel.getSelectionStart() ? editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).column : col;
            RawText rawText = RawText.fromTransferable((Transferable)content);
            String newText = text;
            for (CopyPastePreProcessor preProcessor : (CopyPastePreProcessor[])Extensions.getExtensions(CopyPastePreProcessor.EP_NAME)) {
                newText = preProcessor.preprocessOnPaste(project, file, editor, newText, rawText);
            }
            int indentOptions = text.equals(newText) ? settings.REFORMAT_ON_PASTE : 4;
            text = newText;
            if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) == null && indentOptions != 1) {
                indentOptions = 2;
            }
            final String _text = text;
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)_text, (boolean)false, (boolean)true);
                }
            });
            int length = text.length();
            int offset = caretModel.getOffset() - length;
            if (offset < 0) {
                length += offset;
                offset = 0;
            }
            final RangeMarker bounds = document.createRangeMarker(offset, offset + length);
            caretModel.moveToOffset(bounds.getEndOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            selectionModel.removeSelection();
            final Ref indented = new Ref((Object)Boolean.FALSE);
            for (Map.Entry e : extraData.entrySet()) {
                ((CopyPastePostProcessor)e.getKey()).processTransferableData(project, editor, bounds, caretOffset, (Ref<Boolean>)indented, (TextBlockTransferableData)e.getValue());
            }
            boolean pastedTextContainsWhiteSpacesOnly = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)bounds.getStartOffset(), (String)" \n\t") >= bounds.getEndOffset();
            VirtualFile virtualFile = file.getVirtualFile();
            if (!(pastedTextContainsWhiteSpacesOnly || virtualFile != null && SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile))) {
                final int indentOptions1 = indentOptions;
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        switch (indentOptions1) {
                            case 2: {
                                if (((Boolean)indented.get()).booleanValue()) break;
                                PasteHandler.indentBlock(project, editor, bounds.getStartOffset(), bounds.getEndOffset(), blockIndentAnchorColumn);
                                break;
                            }
                            case 3: {
                                if (((Boolean)indented.get()).booleanValue()) break;
                                PasteHandler.indentEachLine(project, editor, bounds.getStartOffset(), bounds.getEndOffset());
                                break;
                            }
                            case 4: {
                                PasteHandler.indentEachLine(project, editor, bounds.getStartOffset(), bounds.getEndOffset());
                                PasteHandler.reformatBlock(project, editor, bounds.getStartOffset(), bounds.getEndOffset());
                            }
                        }
                    }
                });
            }
            if (bounds.isValid()) {
                caretModel.moveToOffset(bounds.getEndOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                selectionModel.removeSelection();
                editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)TextRange.create((Segment)bounds));
            }
        }
    }

    static void indentBlock(Project project, Editor editor, int startOffset, int endOffset, int originalCaretCol) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitAllDocuments();
        Document document = editor.getDocument();
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file) != null) {
            PasteHandler.indentBlockWithFormatter(project, document, startOffset, endOffset, file);
        } else {
            PasteHandler.indentPlainTextBlock(document, startOffset, endOffset, originalCaretCol);
        }
    }

    private static void indentEachLine(Project project, Editor editor, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CharSequence text = editor.getDocument().getCharsSequence();
        if (startOffset > 0 && endOffset > startOffset + 1 && text.charAt(endOffset - 1) == '\n' && text.charAt(startOffset - 1) == '\n') {
            --endOffset;
        }
        try {
            codeStyleManager.adjustLineIndent(file, new TextRange(startOffset, endOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void reformatBlock(final Project project, final Editor editor, final int startOffset, final int endOffset) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                try {
                    CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, startOffset, endOffset, true);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        if (endOffset - startOffset > 1000) {
            DocumentUtil.executeInBulk(editor.getDocument(), true, task);
        } else {
            task.run();
        }
    }

    private static void indentPlainTextBlock(Document document, int startOffset, int endOffset, int indentLevel) {
        CharSequence chars = document.getCharsSequence();
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
        int line = document.getLineNumber(startOffset);
        if (spaceEnd > endOffset || indentLevel <= 0 || line >= document.getLineCount() - 1 || chars.charAt(spaceEnd) == '\n') {
            return;
        }
        int linesToAdjustIndent = 0;
        for (int i = line + 1; i < document.getLineCount() && document.getLineStartOffset(i) < endOffset; ++i) {
            ++linesToAdjustIndent;
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indentLevel);
        while (linesToAdjustIndent > 0) {
            int lineStartOffset = document.getLineStartOffset(++line);
            document.insertString(lineStartOffset, (CharSequence)indentString);
            --linesToAdjustIndent;
        }
    }

    private static void indentBlockWithFormatter(Project project, Document document, int startOffset, int endOffset, PsiFile file) {
        int lastLine;
        CharSequence chars = document.getCharsSequence();
        int firstLine = document.getLineNumber(startOffset);
        int firstLineStart = document.getLineStartOffset(firstLine);
        boolean saveLastLineIndent = false;
        for (int i = endOffset - 1; i >= startOffset; --i) {
            char c = chars.charAt(i);
            if (c == '\n') {
                saveLastLineIndent = true;
                break;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (saveLastLineIndent) {
            int indentToKeepEndOffset;
            int i;
            lastLine = document.getLineNumber(endOffset) - 1;
            int start = document.getLineStartOffset(lastLine + 1);
            if (start < endOffset && (i = CharArrayUtil.shiftForward((CharSequence)chars, (int)start, (String)" \t")) > start) {
                i = Math.min(i, endOffset);
                document.deleteString(start, i);
            }
            if ((indentToKeepEndOffset = Math.min(startOffset, CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t"))) > firstLineStart) {
                document.insertString(start, chars.subSequence(firstLineStart, indentToKeepEndOffset));
            }
        } else {
            lastLine = document.getLineNumber(endOffset);
        }
        int i = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t");
        if (chars.charAt(startOffset) != '\n' && i > 0 && chars.charAt(i) != '\n') {
            int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (firstNonWsOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, firstNonWsOffset);
                for (int line = firstLine + 1; line <= lastLine; ++line) {
                    document.insertString(document.getLineStartOffset(line), toInsert);
                }
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (file == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        int j = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t\n");
        if (j >= endOffset) {
            return;
        }
        int anchorLine = document.getLineNumber(j);
        int anchorLineStart = document.getLineStartOffset(anchorLine);
        codeStyleManager.adjustLineIndent(file, j);
        if (anchorLine == firstLine && j == startOffset) {
            int indentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (indentOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, indentOffset);
                for (int line = firstLine + 1; line <= lastLine; ++line) {
                    document.insertString(document.getLineStartOffset(line), toInsert);
                }
            }
            return;
        }
        int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)anchorLineStart, (String)" \t");
        int diff = firstNonWsOffset - j;
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            CharSequence toInsert = chars.subSequence(anchorLineStart, anchorLineStart + diff);
            for (int line = anchorLine + 1; line <= lastLine; ++line) {
                document.insertString(document.getLineStartOffset(line), toInsert);
            }
            return;
        }
        if (anchorLine == firstLine && -diff == startOffset - firstLineStart) {
            return;
        }
        if (anchorLine != firstLine || -diff > startOffset - firstLineStart) {
            int desiredSymbolsToRemove = anchorLine == firstLine ? -diff - (startOffset - firstLineStart) : -diff;
            for (int line = anchorLine + 1; line <= lastLine; ++line) {
                int currentLineStart = document.getLineStartOffset(line);
                int currentLineIndentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)currentLineStart, (String)" \t");
                int symbolsToRemove = Math.min(currentLineIndentOffset - currentLineStart, desiredSymbolsToRemove);
                if (symbolsToRemove <= 0) continue;
                document.deleteString(currentLineStart, currentLineStart + symbolsToRemove);
            }
        } else {
            CharSequence toInsert = chars.subSequence(anchorLineStart, diff + startOffset);
            for (int line = anchorLine + 1; line <= lastLine; ++line) {
                document.insertString(document.getLineStartOffset(line), toInsert);
            }
        }
    }
}

