/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypedHandler
extends TypedHandlerDelegate {
    static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.LBRACE, JavaTokenType.RBRACE});
    private boolean myJavaLTTyped;

    private static void autoPopupMemberLookup(Project project, final Editor editor) {
        AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, new Condition<PsiFile>(){

            public boolean value(PsiFile file) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement lastElement = file.findElementAt(offset - 1);
                if (lastElement == null) {
                    return false;
                }
                PsiElement prevSibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastElement);
                if (prevSibling == null || ".".equals(prevSibling.getText())) {
                    return false;
                }
                PsiElement parent = prevSibling;
                while ((parent = parent.getParent()) instanceof PsiJavaCodeReferenceElement || parent instanceof PsiTypeElement) {
                }
                if (parent instanceof PsiParameterList || parent instanceof PsiParameter) {
                    return false;
                }
                if (!".".equals(lastElement.getText()) && !"#".equals(lastElement.getText())) {
                    return JavaClassReferenceCompletionContributor.findJavaClassReference(file, offset - 1) != null;
                }
                PsiElement element = file.findElementAt(offset);
                return element == null || !"#".equals(lastElement.getText()) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) != null;
            }
        });
    }

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (c == '@' && file instanceof PsiJavaFile) {
            JavaTypedHandler.autoPopupJavadocLookup(project, editor);
        } else if (c == '#' || c == '.') {
            JavaTypedHandler.autoPopupMemberLookup(project, editor);
        }
        FileType originalFileType = JavaTypedHandler.getOriginalFileType(file);
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && file instanceof PsiJavaFile && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && JavaTypedHandler.isAfterClassLikeIdentifierOrDot(offsetBefore, editor);
        if ('>' == c && file instanceof PsiJavaFile && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && JavaTypedHandler.handleJavaGT(editor, JavaTokenType.LT, JavaTokenType.GT, INVALID_INSIDE_REFERENCE)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ';' && JavaTypedHandler.handleSemicolon(editor, fileType)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        if (originalFileType == StdFileTypes.JAVA && c == '{') {
            int offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement leaf = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiArrayInitializerExpression.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null) {
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets((Editor)editor, (String)"{");
                TypedHandler.indentOpenedBrace(project, editor);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/editorActions/JavaTypedHandler", "charTyped"));
        }
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            JavaTypedHandler.handleAfterJavaLT(editor, JavaTokenType.LT, JavaTokenType.GT, INVALID_INSIDE_REFERENCE);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == ':' && JavaTypedHandler.autoIndentCase(editor, project, file)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @Nullable
    private static FileType getOriginalFileType(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null ? virtualFile.getFileType() : null;
    }

    private static boolean handleSemicolon(Editor editor, FileType fileType) {
        if (fileType != StdFileTypes.JAVA) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        EditorModificationUtil.moveAllCaretsRelatively((Editor)editor, (int)1);
        return true;
    }

    public static boolean handleJavaGT(Editor editor, IElementType lt, IElementType gt, TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.getTokenType() != gt) {
            return false;
        }
        while (!iterator.atEnd() && !invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (!iterator.atEnd() && invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.retreat();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == lt) {
                --balance;
            } else if (tokenType == gt) {
                ++balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            iterator.retreat();
        }
        if (balance == 0) {
            EditorModificationUtil.moveAllCaretsRelatively((Editor)editor, (int)1);
            return true;
        }
        return false;
    }

    public static void handleAfterJavaLT(Editor editor, IElementType lt, IElementType gt, TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        while (iterator.getStart() > 0 && !invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.retreat();
        }
        if (invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == lt) {
                ++balance;
            } else if (tokenType == gt) {
                --balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            iterator.advance();
        }
        if (balance == 1) {
            if (editor.getCaretModel().supportsMultipleCarets()) {
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets((Editor)editor, (String)">", (int)0);
            } else {
                editor.getDocument().insertString(offset, (CharSequence)">");
            }
        }
    }

    private static void autoPopupJavadocLookup(Project project, final Editor editor) {
        AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, new Condition<PsiFile>(){

            public boolean value(PsiFile file) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement lastElement = file.findElementAt(offset - 1);
                return lastElement != null && StringUtil.endsWithChar((CharSequence)lastElement.getText(), (char)'@');
            }
        });
    }

    public static boolean isAfterClassLikeIdentifierOrDot(int offset, Editor editor) {
        IElementType tokenType;
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        if ((tokenType = iterator.getTokenType()) == JavaTokenType.DOT) {
            return true;
        }
        return JavaTypedHandler.isClassLikeIdentifier(offset, editor, iterator, JavaTokenType.IDENTIFIER);
    }

    public static boolean isClassLikeIdentifier(int offset, Editor editor, HighlighterIterator iterator, IElementType idType) {
        if (iterator.getTokenType() == idType && iterator.getEnd() == offset) {
            CharSequence chars = editor.getDocument().getCharsSequence();
            char startChar = chars.charAt(iterator.getStart());
            if (!Character.isUpperCase(startChar)) {
                return false;
            }
            CharSequence word = chars.subSequence(iterator.getStart(), iterator.getEnd());
            if (word.length() == 1) {
                return true;
            }
            for (int i = 1; i < word.length(); ++i) {
                if (!Character.isLowerCase(word.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean autoIndentCase(Editor editor, Project project, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null && (parent = currElement.getParent()) != null && parent instanceof PsiSwitchLabelStatement) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, parent.getTextOffset());
            return true;
        }
        return false;
    }
}

