/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.CommentCompleteHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterHandler
extends BaseEnterHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.EnterHandler");
    private final EditorActionHandler myOriginalHandler;

    public EnterHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.myOriginalHandler.isEnabled(editor, dataContext);
    }

    public void executeWriteAction(final Editor editor, final Caret caret, final DataContext dataContext) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && !project.isDefault()) {
            PostprocessReformattingAspect.getInstance(project).disablePostprocessFormattingInside(new Runnable(){

                @Override
                public void run() {
                    EnterHandler.this.executeWriteActionInner(editor, caret, dataContext, project);
                }
            });
        } else {
            this.executeWriteActionInner(editor, caret, dataContext, project);
        }
    }

    private void executeWriteActionInner(Editor editor, Caret caret, DataContext dataContext, Project project) {
        EnterHandlerDelegate[] delegates;
        int offset1;
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (project == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        Document document = editor.getDocument();
        PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        CommandProcessor.getInstance().setCurrentCommandName(CodeInsightBundle.message((String)"command.name.typing", (Object[])new Object[0]));
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text = document.getCharsSequence();
        int length = document.getTextLength();
        if (caretOffset < length && text.charAt(caretOffset) != '\n' && ((offset1 = CharArrayUtil.shiftBackward((CharSequence)text, (int)caretOffset, (String)" \t")) < 0 || text.charAt(offset1) == '\n')) {
            boolean isEmptyLine;
            int offset2 = CharArrayUtil.shiftForward((CharSequence)text, (int)(offset1 + 1), (String)" \t");
            boolean bl = isEmptyLine = offset2 >= length || text.charAt(offset2) == '\n';
            if (!isEmptyLine) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
                return;
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        boolean forceIndent = false;
        boolean forceSkipIndent = false;
        Ref caretOffsetRef = new Ref((Object)caretOffset);
        Ref caretAdvanceRef = new Ref((Object)0);
        for (EnterHandlerDelegate delegate : delegates = (EnterHandlerDelegate[])Extensions.getExtensions(EnterHandlerDelegate.EP_NAME)) {
            EnterHandlerDelegate.Result result = delegate.preprocessEnter(file, editor, (Ref<Integer>)caretOffsetRef, (Ref<Integer>)caretAdvanceRef, dataContext, this.myOriginalHandler);
            if ((Integer)caretOffsetRef.get() > document.getTextLength()) {
                throw new AssertionError((Object)("Wrong caret offset change by " + delegate));
            }
            if (result == EnterHandlerDelegate.Result.Stop) {
                return;
            }
            if (result == EnterHandlerDelegate.Result.Continue) continue;
            if (result == EnterHandlerDelegate.Result.DefaultForceIndent) {
                forceIndent = true;
                break;
            }
            if (result != EnterHandlerDelegate.Result.DefaultSkipIndent) break;
            forceSkipIndent = true;
            break;
        }
        text = document.getCharsSequence();
        caretOffset = (Integer)caretOffsetRef.get();
        boolean isFirstColumn = caretOffset == 0 || text.charAt(caretOffset - 1) == '\n';
        boolean insertSpace = !isFirstColumn && caretOffset < text.length() && text.charAt(caretOffset) != ' ' && text.charAt(caretOffset) != '\t';
        editor.getCaretModel().moveToOffset(caretOffset);
        this.myOriginalHandler.execute(editor, caret, dataContext);
        if (!editor.isInsertMode() || forceSkipIndent) {
            return;
        }
        if (settings.SMART_INDENT_ON_ENTER || forceIndent) {
            ++caretOffset;
            caretOffset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)caretOffset, (String)" \t");
        } else {
            caretOffset = editor.getCaretModel().getOffset();
        }
        documentManager.commitAllDocuments();
        DoEnterAction action = new DoEnterAction(file, editor, document, dataContext, caretOffset, !insertSpace, (Integer)caretAdvanceRef.get(), project);
        action.setForceIndent(forceIndent);
        action.run();
        documentManager.commitDocument(document);
        for (EnterHandlerDelegate delegate : delegates) {
            if (delegate.postProcessEnter(file, editor, dataContext) == EnterHandlerDelegate.Result.Stop) break;
        }
        documentManager.commitDocument(document);
    }

    private static boolean isCommentComplete(PsiComment comment, CodeDocumentationAwareCommenter commenter, Editor editor) {
        JavaLikeQuoteHandler javaLikeQuoteHandler;
        String expectedCommentEnd;
        for (CommentCompleteHandler handler : (CommentCompleteHandler[])Extensions.getExtensions(CommentCompleteHandler.EP_NAME)) {
            if (!handler.isApplicable(comment, commenter)) continue;
            return handler.isCommentComplete(comment, commenter, editor);
        }
        String commentText = comment.getText();
        boolean docComment = EnterHandler.isDocComment((PsiElement)comment, commenter);
        String string = expectedCommentEnd = docComment ? commenter.getDocumentationCommentSuffix() : commenter.getBlockCommentSuffix();
        if (!commentText.endsWith(expectedCommentEnd)) {
            return false;
        }
        PsiFile containingFile = comment.getContainingFile();
        Language language = containingFile.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition == null) {
            return true;
        }
        Lexer lexer = parserDefinition.createLexer(containingFile.getProject());
        String commentPrefix = docComment ? commenter.getDocumentationCommentPrefix() : commenter.getBlockCommentPrefix();
        lexer.start((CharSequence)commentText, commentPrefix == null ? 0 : commentPrefix.length(), commentText.length());
        QuoteHandler fileTypeHandler = TypedHandler.getQuoteHandler(containingFile, editor);
        JavaLikeQuoteHandler javaLikeQuoteHandler2 = javaLikeQuoteHandler = fileTypeHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeHandler : null;
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (javaLikeQuoteHandler != null && javaLikeQuoteHandler.getStringTokenTypes() != null && javaLikeQuoteHandler.getStringTokenTypes().contains(tokenType)) {
                String text = commentText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                int endOffset = comment.getTextRange().getEndOffset();
                if (text.endsWith(expectedCommentEnd) && endOffset < containingFile.getTextLength() && containingFile.getText().charAt(endOffset) == '\n') {
                    return true;
                }
            }
            if (tokenType == commenter.getDocumentationCommentTokenType() || tokenType == commenter.getBlockCommentTokenType()) {
                return false;
            }
            if (tokenType == commenter.getLineCommentTokenType() && lexer.getTokenText().contains(commentPrefix)) {
                return false;
            }
            if (lexer.getTokenEnd() == commentText.length()) {
                if (tokenType == commenter.getLineCommentTokenType()) {
                    String prefix = commenter.getLineCommentPrefix();
                    lexer.start((CharSequence)commentText, lexer.getTokenStart() + (prefix == null ? 0 : prefix.length()), commentText.length());
                    lexer.advance();
                    continue;
                }
                return !EnterHandler.isInvalidPsi((PsiElement)comment);
            }
            lexer.advance();
        }
        return false;
    }

    private static boolean isInvalidPsi(@NotNull PsiElement base) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/editorActions/EnterHandler", "isInvalidPsi"));
        }
        for (PsiElement current = base.getNextSibling(); current != null; current = current.getNextSibling()) {
            if (current.getTextLength() == 0) continue;
            return current instanceof PsiErrorElement;
        }
        return false;
    }

    private static boolean isDocComment(PsiElement element, CodeDocumentationAwareCommenter commenter) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        return commenter.isDocumentationComment(comment);
    }

    private static class DoEnterAction
    implements Runnable {
        private final DataContext myDataContext;
        private final PsiFile myFile;
        private int myOffset;
        private final Document myDocument;
        private final boolean myInsertSpace;
        private final Editor myEditor;
        private final Project myProject;
        private int myCaretAdvance;
        private boolean myForceIndent = false;
        private static final String LINE_SEPARATOR = "\n";

        public DoEnterAction(PsiFile file, Editor view, Document document, DataContext dataContext, int offset, boolean insertSpace, int caretAdvance, Project project) {
            this.myEditor = view;
            this.myFile = file;
            this.myDataContext = dataContext;
            this.myOffset = offset;
            this.myDocument = document;
            this.myInsertSpace = insertSpace;
            this.myCaretAdvance = caretAdvance;
            this.myProject = project;
        }

        public void setForceIndent(boolean forceIndent) {
            this.myForceIndent = forceIndent;
        }

        @Override
        public void run() {
            CaretModel caretModel = this.myEditor.getCaretModel();
            try {
                int line;
                PsiElement element;
                CharSequence chars = this.myDocument.getCharsSequence();
                int i = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)(this.myOffset - 1), (String)LINE_SEPARATOR) - 1;
                i = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)i, (String)LINE_SEPARATOR) + 1;
                if (i < 0) {
                    i = 0;
                }
                int lineStart = CharArrayUtil.shiftForward((CharSequence)chars, (int)i, (String)" \t");
                CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(this.myFile, chars, this.myOffset, lineStart);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                if (commentContext.docStart) {
                    element = this.myFile.findElementAt(commentContext.lineStart);
                    String text = element.getText();
                    PsiElement parent = element.getParent();
                    if (text.equals(commentContext.commenter.getDocumentationCommentPrefix()) && EnterHandler.isDocComment(parent, commentContext.commenter) || text.startsWith(commentContext.commenter.getDocumentationCommentPrefix()) && element instanceof PsiComment) {
                        PsiComment comment = EnterHandler.isDocComment(parent, commentContext.commenter) ? (PsiComment)parent : (PsiComment)element;
                        int commentEnd = comment.getTextRange().getEndOffset();
                        if (this.myOffset >= commentEnd) {
                            commentContext.docStart = false;
                        } else if (EnterHandler.isCommentComplete(comment, commentContext.commenter, this.myEditor)) {
                            if (this.myOffset >= commentEnd) {
                                commentContext.docAsterisk = false;
                                commentContext.docStart = false;
                            } else {
                                commentContext.docAsterisk = true;
                                commentContext.docStart = false;
                            }
                        } else {
                            this.generateJavadoc(commentContext.commenter);
                        }
                    } else {
                        commentContext.docStart = false;
                    }
                } else if (commentContext.cStyleStart) {
                    element = this.myFile.findElementAt(commentContext.lineStart);
                    if (element instanceof PsiComment && commentContext.commenter.getBlockCommentTokenType() == ((PsiComment)element).getTokenType()) {
                        PsiComment comment = (PsiComment)element;
                        int commentEnd = comment.getTextRange().getEndOffset();
                        if (this.myOffset >= commentEnd && this.myOffset < this.myFile.getTextRange().getEndOffset()) {
                            commentContext.docStart = false;
                        } else if (EnterHandler.isCommentComplete(comment, commentContext.commenter, this.myEditor)) {
                            if (this.myOffset >= commentEnd) {
                                commentContext.docAsterisk = false;
                                commentContext.docStart = false;
                            } else {
                                commentContext.docAsterisk = true;
                                commentContext.docStart = false;
                            }
                        } else {
                            int currentEndOfLine = CharArrayUtil.shiftForwardUntil((CharSequence)chars, (int)this.myOffset, (String)LINE_SEPARATOR);
                            this.myDocument.insertString(currentEndOfLine, (CharSequence)(" " + commentContext.commenter.getBlockCommentSuffix()));
                            int lstart = CharArrayUtil.shiftBackwardUntil((CharSequence)chars, (int)this.myOffset, (String)LINE_SEPARATOR);
                            this.myDocument.insertString(currentEndOfLine, chars.subSequence(lstart, this.myOffset));
                            psiDocumentManager.commitDocument(this.myDocument);
                        }
                    } else {
                        commentContext.docStart = false;
                    }
                }
                String indentInsideJavadoc = null;
                if (this.myOffset < this.myDocument.getTextLength() && (line = this.myDocument.getLineNumber(this.myOffset)) > 0 && (commentContext.docAsterisk || commentContext.docStart)) {
                    indentInsideJavadoc = CodeDocumentationUtil.getIndentInsideJavadoc(this.myDocument, this.myDocument.getLineStartOffset(line - 1));
                }
                if (commentContext.docAsterisk) {
                    commentContext.docAsterisk = this.insertDocAsterisk(commentContext.lineStart, commentContext.docAsterisk, !StringUtil.isEmpty(indentInsideJavadoc), commentContext.commenter);
                }
                boolean docIndentApplied = false;
                CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
                if (codeInsightSettings.SMART_INDENT_ON_ENTER || this.myForceIndent || commentContext.docStart || commentContext.docAsterisk || commentContext.slashSlash) {
                    CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.getProject());
                    this.myOffset = codeStyleManager.adjustLineIndent(this.myFile, this.myOffset);
                    psiDocumentManager.commitAllDocuments();
                    if (!StringUtil.isEmpty((String)indentInsideJavadoc) && this.myOffset < this.myDocument.getTextLength()) {
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)indentInsideJavadoc);
                        this.myOffset += indentInsideJavadoc.length();
                        docIndentApplied = true;
                    }
                    if (this.myForceIndent && indentInsideJavadoc != null) {
                        int indentSize = CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentSize(this.myFile.getFileType());
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)StringUtil.repeatSymbol((char)' ', (int)indentSize));
                        this.myCaretAdvance += indentSize;
                    }
                }
                if ((commentContext.docAsterisk || commentContext.docStart || commentContext.slashSlash) && !docIndentApplied) {
                    char c;
                    if (this.myInsertSpace) {
                        if (this.myOffset == this.myDocument.getTextLength()) {
                            this.myDocument.insertString(this.myOffset, (CharSequence)" ");
                        }
                        this.myDocument.insertString(this.myOffset + 1, (CharSequence)" ");
                    }
                    if ((c = this.myDocument.getCharsSequence().charAt(this.myOffset)) != '\n') {
                        ++this.myOffset;
                    }
                }
                if ((commentContext.docAsterisk || commentContext.slashSlash) && !commentContext.docStart) {
                    this.myCaretAdvance += commentContext.slashSlash ? commentContext.commenter.getLineCommentPrefix().trim().length() : 1;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
            this.myOffset = Math.min(this.myOffset, this.myDocument.getTextLength());
            caretModel.moveToOffset(this.myOffset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
            if (this.myCaretAdvance != 0) {
                LogicalPosition caretPosition = caretModel.getLogicalPosition();
                LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + this.myCaretAdvance);
                caretModel.moveToLogicalPosition(pos);
            }
        }

        private void generateJavadoc(CodeDocumentationAwareCommenter commenter) throws IncorrectOperationException {
            CodeInsightSettings settings = CodeInsightSettings.getInstance();
            StringBuilder buffer = new StringBuilder();
            String docCommentLinePrefix = commenter.getDocumentationCommentLinePrefix();
            if (docCommentLinePrefix == null) {
                return;
            }
            buffer.append(docCommentLinePrefix);
            if (DataManager.getInstance().loadFromDataContext(this.myDataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) == Boolean.TRUE) {
                this.myDocument.insertString(this.myOffset, (CharSequence)buffer);
                buffer = new StringBuilder(LINE_SEPARATOR).append(commenter.getDocumentationCommentSuffix());
                int line = this.myDocument.getLineNumber(this.myOffset);
                this.myOffset = this.myDocument.getLineEndOffset(line);
            } else {
                buffer.append(LINE_SEPARATOR);
                buffer.append(commenter.getDocumentationCommentSuffix());
            }
            PsiComment comment = this.createComment(buffer, settings);
            if (comment == null) {
                return;
            }
            this.myOffset = comment.getTextRange().getStartOffset();
            CharSequence text = this.myDocument.getCharsSequence();
            this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)this.myOffset, (String)LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)this.myOffset, (String)LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)this.myOffset, (String)docCommentLinePrefix) + 1;
            DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
            if (!CodeStyleSettingsManager.getSettings((Project)this.getProject()).JD_LEADING_ASTERISKS_ARE_ENABLED) {
                LOG.assertTrue(CharArrayUtil.regionMatches((CharSequence)this.myDocument.getCharsSequence(), (int)(this.myOffset - docCommentLinePrefix.length()), (CharSequence)docCommentLinePrefix));
                this.myDocument.deleteString(this.myOffset - docCommentLinePrefix.length(), this.myOffset);
                --this.myOffset;
            } else {
                this.myDocument.insertString(this.myOffset, (CharSequence)" ");
                ++this.myOffset;
            }
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private PsiComment createComment(CharSequence buffer, CodeInsightSettings settings) throws IncorrectOperationException {
            this.myDocument.insertString(this.myOffset, buffer);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
            CodeStyleManager.getInstance((Project)this.getProject()).adjustLineIndent(this.myFile, this.myOffset + buffer.length() - 2);
            PsiComment comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            comment = this.createJavaDocStub(settings, comment, this.getProject());
            if (comment == null) {
                return null;
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.getProject());
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)this.getProject());
            boolean old = codeStyleSettings.ENABLE_JAVADOC_FORMATTING;
            codeStyleSettings.ENABLE_JAVADOC_FORMATTING = false;
            try {
                comment = (PsiComment)codeStyleManager.reformat((PsiElement)comment);
            }
            finally {
                codeStyleSettings.ENABLE_JAVADOC_FORMATTING = old;
            }
            PsiElement next = comment.getNextSibling();
            if (next == null && comment.getParent().getClass() == comment.getClass()) {
                next = comment.getParent().getNextSibling();
            }
            if (next != null) {
                next = this.myFile.findElementAt(next.getTextRange().getStartOffset());
            }
            if (!(next == null || FormatterUtil.containsWhiteSpacesOnly(next.getNode()) && next.getText().contains(LINE_SEPARATOR))) {
                int lineBreakOffset = comment.getTextRange().getEndOffset();
                this.myDocument.insertString(lineBreakOffset, (CharSequence)LINE_SEPARATOR);
                PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                codeStyleManager.adjustLineIndent(this.myFile, lineBreakOffset + 1);
                comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            }
            return comment;
        }

        @Nullable
        private PsiComment createJavaDocStub(CodeInsightSettings settings, PsiComment comment, Project project) {
            if (settings.JAVADOC_STUB_ON_ENTER) {
                CodeDocumentationProvider docProvider;
                DocumentationProvider langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(comment.getParent().getLanguage());
                if (langDocumentationProvider instanceof CompositeDocumentationProvider) {
                    docProvider = ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider();
                } else {
                    CodeDocumentationProvider codeDocumentationProvider = docProvider = langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null;
                }
                if (docProvider != null) {
                    if (docProvider.findExistingDocComment(comment) != comment) {
                        return comment;
                    }
                    String docStub = docProvider.generateDocumentationContentStub(comment);
                    if (docStub != null && docStub.length() != 0) {
                        this.myOffset = CharArrayUtil.shiftForwardUntil((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
                        this.myOffset = CharArrayUtil.shiftForward((CharSequence)this.myDocument.getCharsSequence(), (int)this.myOffset, (String)LINE_SEPARATOR);
                        this.myDocument.insertString(this.myOffset, (CharSequence)docStub);
                    }
                }
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                return (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myFile.findElementAt(this.myOffset), (Class[])new Class[]{PsiComment.class});
            }
            return comment;
        }

        private Project getProject() {
            return this.myFile.getProject();
        }

        private static void removeTrailingSpaces(Document document, int startOffset) {
            int endOffset = startOffset;
            CharSequence charsSequence = document.getCharsSequence();
            for (int i = startOffset; i < charsSequence.length(); ++i) {
                char c = charsSequence.charAt(i);
                endOffset = i;
                if (c == '\n') break;
                if (c == ' ' || c == '\t') continue;
                return;
            }
            document.deleteString(startOffset, endOffset);
        }

        private boolean insertDocAsterisk(int lineStart, boolean docAsterisk, boolean previousLineIndentUsed, CodeDocumentationAwareCommenter commenter) {
            PsiElement atLineStart = this.myFile.findElementAt(lineStart);
            if (atLineStart == null) {
                return false;
            }
            String linePrefix = commenter.getDocumentationCommentLinePrefix();
            String docPrefix = commenter.getDocumentationCommentPrefix();
            String text = atLineStart.getText();
            TextRange textRange = atLineStart.getTextRange();
            if (text.equals(linePrefix) || text.equals(docPrefix) || docPrefix != null && text.regionMatches(lineStart - textRange.getStartOffset(), docPrefix, 0, docPrefix.length()) || linePrefix != null && text.regionMatches(lineStart - textRange.getStartOffset(), linePrefix, 0, linePrefix.length())) {
                PsiComment comment;
                PsiElement element = this.myFile.findElementAt(this.myOffset);
                if (element == null) {
                    return false;
                }
                PsiComment psiComment = comment = element instanceof PsiComment ? (PsiComment)element : (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
                if (comment != null) {
                    int commentEnd = comment.getTextRange().getEndOffset();
                    if (this.myOffset >= commentEnd) {
                        docAsterisk = false;
                    } else {
                        DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
                        String toInsert = previousLineIndentUsed ? "*" : CodeDocumentationUtil.createDocCommentLine("", this.getProject(), commenter);
                        this.myDocument.insertString(this.myOffset, (CharSequence)toInsert);
                        PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                    }
                } else {
                    docAsterisk = false;
                }
            } else if (linePrefix != null && atLineStart instanceof PsiComment && ((PsiComment)atLineStart).getTokenType() == commenter.getBlockCommentTokenType()) {
                int nextLineOffset;
                boolean usesAstersk = false;
                int commentLine = this.myDocument.getLineNumber(textRange.getStartOffset());
                if (commentLine < this.myDocument.getLineCount() - 1 && textRange.getEndOffset() >= this.myOffset && (nextLineOffset = this.myDocument.getLineStartOffset(commentLine + 1)) < textRange.getEndOffset()) {
                    CharSequence chars = this.myDocument.getCharsSequence();
                    nextLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)nextLineOffset, (String)" \t");
                    usesAstersk = CharArrayUtil.regionMatches((CharSequence)chars, (int)nextLineOffset, (CharSequence)linePrefix);
                }
                if (usesAstersk) {
                    DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
                    this.myDocument.insertString(this.myOffset, (CharSequence)(linePrefix + " "));
                    PsiDocumentManager.getInstance((Project)this.getProject()).commitAllDocuments();
                }
                docAsterisk = usesAstersk;
            } else {
                docAsterisk = false;
            }
            return docAsterisk;
        }
    }
}

