/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;

public class CopyHandler
extends EditorActionHandler {
    private final EditorActionHandler myOriginalAction;

    public CopyHandler(EditorActionHandler originalHandler) {
        this.myOriginalAction = originalHandler;
    }

    public void execute(final Editor editor, DataContext dataContext) {
        EditorEx ex;
        CopyPastePreProcessor processor;
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)editor.getComponent()));
        if (project == null) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, dataContext);
            }
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (file == null || settings.ADD_IMPORTS_ON_PASTE == 2) {
            if (this.myOriginalAction != null) {
                this.myOriginalAction.execute(editor, dataContext);
            }
            return;
        }
        final SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true) && !selectionModel.hasBlockSelection()) {
            if (Registry.is((String)"editor.skip.copy.and.cut.for.empty.selection")) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    selectionModel.selectLineAtCaret();
                }
            });
            if (!selectionModel.hasSelection(true)) {
                return;
            }
            editor.getCaretModel().runForEachCaret(new CaretAction(){

                public void perform(Caret caret) {
                    EditorActionUtil.moveCaretToLineStartIgnoringSoftWraps(editor);
                }
            });
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int[] startOffsets = selectionModel.getBlockSelectionStarts();
        int[] endOffsets = selectionModel.getBlockSelectionEnds();
        ArrayList<TextBlockTransferableData> transferableDatas = new ArrayList<TextBlockTransferableData>();
        for (CopyPastePostProcessor processor2 : (CopyPastePostProcessor[])Extensions.getExtensions(CopyPastePostProcessor.EP_NAME)) {
            Object e = processor2.collectTransferableData(file, editor, startOffsets, endOffsets);
            if (e == null) continue;
            transferableDatas.add((TextBlockTransferableData)e);
        }
        String rawText = TextBlockTransferable.convertLineSeparators(selectionModel.getSelectedText(true), "\n", transferableDatas);
        String escapedText = null;
        CopyPastePreProcessor[] arr$ = (CopyPastePreProcessor[])Extensions.getExtensions(CopyPastePreProcessor.EP_NAME);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (escapedText = (processor = arr$[i$]).preprocessOnCopy(file, startOffsets, endOffsets, rawText)) == null; ++i$) {
        }
        TextBlockTransferable transferable = new TextBlockTransferable(escapedText != null ? escapedText : rawText, transferableDatas, escapedText != null ? new RawText(rawText) : null);
        CopyPasteManager.getInstance().setContents((Transferable)transferable);
        if (editor instanceof EditorEx && (ex = (EditorEx)editor).isStickySelection()) {
            ex.setStickySelection(false);
        }
    }
}

