/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.javaDoc.JavaDocLocalInspection;
import com.intellij.codeInspection.javaDoc.JavaDocReferenceInspection;
import com.intellij.javadoc.JavadocNavigationDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaDocCommentFixer
implements DocCommentFixer {
    @NotNull
    private static final String PARAM_TAG = "@param";
    @NotNull
    private static final Set<String> CARET_ANCHOR_TAGS = ContainerUtilRt.newHashSet((Object[])new String[]{"@param", "@throws", "@return"});
    @NotNull
    private static final Comparator<PsiElement> COMPARATOR = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement e1, PsiElement e2) {
            return e2.getTextRange().getEndOffset() - e1.getTextRange().getEndOffset();
        }
    };
    @NotNull
    private static final String PARAM_TAG_NAME = "param";

    @Override
    public void fixComment(@NotNull Project project, @NotNull Editor editor, @NotNull PsiComment comment) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixComment"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixComment"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixComment"));
        }
        if (!(comment instanceof PsiDocComment)) {
            return;
        }
        PsiDocComment docComment = (PsiDocComment)comment;
        PsiDocCommentOwner owner = docComment.getOwner();
        if (owner == null) {
            return;
        }
        PsiFile file = comment.getContainingFile();
        if (file == null) {
            return;
        }
        JavaDocReferenceInspection referenceInspection = new JavaDocReferenceInspection();
        JavaDocLocalInspection localInspection = JavaDocCommentFixer.getDocLocalInspection();
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)project);
        ProblemDescriptor[] referenceProblems = null;
        ProblemDescriptor[] otherProblems = null;
        if (owner instanceof PsiClass) {
            referenceProblems = referenceInspection.checkClass((PsiClass)owner, inspectionManager, false);
            otherProblems = localInspection.checkClass((PsiClass)owner, inspectionManager, false);
        } else if (owner instanceof PsiField) {
            referenceProblems = referenceInspection.checkField((PsiField)owner, inspectionManager, false);
            otherProblems = localInspection.checkField((PsiField)owner, inspectionManager, false);
        } else if (owner instanceof PsiMethod) {
            referenceProblems = referenceInspection.checkMethod((PsiMethod)owner, inspectionManager, false);
            otherProblems = localInspection.checkMethod((PsiMethod)owner, inspectionManager, false);
        }
        if (referenceProblems != null) {
            JavaDocCommentFixer.fixReferenceProblems(referenceProblems, project);
        }
        if (otherProblems != null) {
            JavaDocCommentFixer.fixCommonProblems(otherProblems, comment, editor.getDocument(), project);
        }
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        JavaDocCommentFixer.ensureContentOrdered(docComment, editor.getDocument());
        JavaDocCommentFixer.locateCaret(docComment, editor, file);
    }

    @NotNull
    private static JavaDocLocalInspection getDocLocalInspection() {
        JavaDocLocalInspection localInspection = new JavaDocLocalInspection();
        localInspection.TOP_LEVEL_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.INNER_CLASS_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.FIELD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.METHOD_OPTIONS.ACCESS_JAVADOC_REQUIRED_FOR = "private";
        localInspection.setIgnoreEmptyDescriptions(true);
        if (!localInspection.TOP_LEVEL_CLASS_OPTIONS.REQUIRED_TAGS.contains(PARAM_TAG)) {
            localInspection.TOP_LEVEL_CLASS_OPTIONS.REQUIRED_TAGS = localInspection.TOP_LEVEL_CLASS_OPTIONS.REQUIRED_TAGS + PARAM_TAG;
        }
        if (!localInspection.INNER_CLASS_OPTIONS.REQUIRED_TAGS.contains(PARAM_TAG)) {
            localInspection.INNER_CLASS_OPTIONS.REQUIRED_TAGS = localInspection.INNER_CLASS_OPTIONS.REQUIRED_TAGS + PARAM_TAG;
        }
        JavaDocLocalInspection javaDocLocalInspection = localInspection;
        if (javaDocLocalInspection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "getDocLocalInspection"));
        }
        return javaDocLocalInspection;
    }

    private static void fixReferenceProblems(@NotNull ProblemDescriptor[] problems, @NotNull Project project) {
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixReferenceProblems"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixReferenceProblems"));
        }
        for (ProblemDescriptor problem : problems) {
            QuickFix[] fixes = problem.getFixes();
            if (fixes == null) continue;
            fixes[0].applyFix(project, (CommonProblemDescriptor)problem);
        }
    }

    private static void fixCommonProblems(@NotNull ProblemDescriptor[] problems, @NotNull PsiComment comment, @NotNull Document document, @NotNull Project project) {
        if (problems == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixCommonProblems"));
        }
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixCommonProblems"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixCommonProblems"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "fixCommonProblems"));
        }
        ArrayList<PsiElement> toRemove = new ArrayList<PsiElement>();
        block0: for (ProblemDescriptor problem : problems) {
            PsiElement element = problem.getPsiElement();
            if (element == null) continue;
            if (!(element instanceof PsiDocToken && JavaDocTokenType.DOC_COMMENT_START.equals(((PsiDocToken)element).getTokenType()) || !comment.getTextRange().contains(element.getTextRange()))) {
                for (PsiElement e = element; e != null; e = e.getParent()) {
                    if (!(e instanceof PsiDocTag)) continue;
                    toRemove.add(e);
                    continue block0;
                }
                continue;
            }
            QuickFix[] fixes = problem.getFixes();
            if (fixes == null || fixes.length <= 0) continue;
            fixes[0].applyFix(project, (CommonProblemDescriptor)problem);
        }
        if (toRemove.isEmpty()) {
            return;
        }
        if (toRemove.size() > 1) {
            Collections.sort(toRemove, COMPARATOR);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        CharSequence text = document.getCharsSequence();
        for (PsiElement element : toRemove) {
            int endOffset;
            char c;
            int startOffset = element.getTextRange().getStartOffset();
            int startLine = document.getLineNumber(startOffset);
            int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(startOffset - 1), (String)" \t");
            if (i >= 0 && (c = text.charAt(i)) == '*') {
                i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(i - 1), (String)" \t");
            }
            if (i >= 0 && text.charAt(i) == '\n') {
                startOffset = Math.max(i, document.getLineStartOffset(startLine) - 1);
            }
            if ((i = CharArrayUtil.shiftBackward((CharSequence)text, (int)((endOffset = element.getTextRange().getEndOffset()) - 1), (String)" \t*")) > 0 && text.charAt(i) == '\n') {
                endOffset = i;
            }
            document.deleteString(startOffset, endOffset);
        }
        psiDocumentManager.commitDocument(document);
    }

    private static void ensureContentOrdered(@NotNull PsiDocComment comment, @NotNull Document document) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "ensureContentOrdered"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "ensureContentOrdered"));
        }
        ArrayList<String> current = new ArrayList<String>();
        HashMap<String, Pair<TextRange, String>> tagInfoByName = new HashMap<String, Pair<TextRange, String>>();
        for (PsiDocTag tag : comment.getTags()) {
            String paramName;
            PsiDocTagValue valueElement;
            if (!PARAM_TAG_NAME.equals(tag.getName()) || (valueElement = tag.getValueElement()) == null || (paramName = valueElement.getText()) == null) continue;
            current.add(paramName);
            tagInfoByName.put(paramName, JavaDocCommentFixer.parseTagValue(tag, document));
        }
        ArrayList<String> ordered = new ArrayList<String>();
        PsiDocCommentOwner owner = comment.getOwner();
        if (owner instanceof PsiMethod) {
            PsiParameter[] parameters;
            for (PsiParameter psiParameter : parameters = ((PsiMethod)owner).getParameterList().getParameters()) {
                ordered.add(psiParameter.getName());
            }
        }
        if (owner instanceof PsiTypeParameterListOwner) {
            PsiTypeParameter[] typeParameters = ((PsiTypeParameterListOwner)owner).getTypeParameters();
            for (PsiParameter psiParameter : typeParameters) {
                ordered.add(String.format("<%s>", psiParameter.getName()));
            }
        }
        if (current.size() != ordered.size()) {
            return;
        }
        boolean changed = false;
        for (int i = current.size() - 1; i >= 0; --i) {
            String oldTag;
            String newTag = (String)ordered.get(i);
            if (newTag.equals(oldTag = (String)current.get(i))) continue;
            TextRange textRange = (TextRange)((Pair)tagInfoByName.get((Object)oldTag)).first;
            document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)((Pair)tagInfoByName.get((Object)newTag)).second);
            changed = true;
        }
        if (changed) {
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)comment.getProject());
            manager.commitDocument(document);
        }
    }

    @NotNull
    private static Pair<TextRange, String> parseTagValue(@NotNull PsiDocTag tag, @NotNull Document document) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "parseTagValue"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "parseTagValue"));
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        assert (valueElement != null);
        int startOffset = valueElement.getTextRange().getStartOffset();
        int endOffset = tag.getTextRange().getEndOffset();
        CharSequence text = document.getCharsSequence();
        int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(endOffset - 1), (String)" \t*");
        if (i > 0 && text.charAt(i) == '\n') {
            endOffset = i;
        }
        Pair pair = Pair.create((Object)TextRange.create((int)startOffset, (int)endOffset), (Object)((Object)text.subSequence(startOffset, endOffset)).toString());
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "parseTagValue"));
        }
        return pair;
    }

    private static void locateCaret(@NotNull PsiDocComment comment, @NotNull Editor editor, @NotNull PsiFile file) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "locateCaret"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "locateCaret"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/documentation/JavaDocCommentFixer", "locateCaret"));
        }
        Document document = editor.getDocument();
        int lineToNavigate = -1;
        for (PsiDocTag tag : comment.getTags()) {
            PsiElement nameElement = tag.getNameElement();
            if (nameElement == null || !CARET_ANCHOR_TAGS.contains(nameElement.getText())) continue;
            boolean good = false;
            PsiElement[] dataElements = tag.getDataElements();
            if (dataElements != null) {
                PsiDocTagValue valueElement = tag.getValueElement();
                for (PsiElement element : dataElements) {
                    if (element == valueElement || StringUtil.isEmptyOrSpaces((String)element.getText())) continue;
                    good = true;
                    break;
                }
            }
            if (good) continue;
            int offset = tag.getTextRange().getEndOffset();
            CharSequence text = document.getCharsSequence();
            int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(offset - 1), (String)" \t*");
            if (i > 0 && text.charAt(i) == '\n') {
                offset = i - 1;
            }
            lineToNavigate = document.getLineNumber(offset);
            break;
        }
        if (lineToNavigate >= 0) {
            editor.getCaretModel().moveToOffset(document.getLineEndOffset(lineToNavigate));
            JavadocNavigationDelegate.navigateToLineEnd(editor, file);
        }
    }
}

