/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFile;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalFilter {
    private static final boolean EXTRACT_IMAGES_FROM_JARS = SystemProperties.getBooleanProperty((String)"extract.doc.images", (boolean)true);
    @NotNull
    public static final String QUICK_DOC_DIR_NAME = "quickdoc";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocExternalFilter");
    private static final Pattern ourClassDataStartPattern = Pattern.compile("START OF CLASS DATA", 2);
    private static final Pattern ourClassDataEndPattern = Pattern.compile("SUMMARY ========", 2);
    private static final Pattern ourNonClassDataEndPattern = Pattern.compile("<A NAME=", 2);
    @NonNls
    protected static final Pattern ourAnchorsuffix = Pattern.compile("#(.*)$");
    @NonNls
    protected static final Pattern ourHTMLFilesuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    @NonNls
    private static final Pattern ourAnnihilator = Pattern.compile("/[^/^.]*/[.][.]/");
    @NonNls
    private static final Pattern ourIMGselector = Pattern.compile("<IMG[ \\t\\n\\r\\f]+SRC=\"([^>]*?)\"", 34);
    @NonNls
    private static final Pattern ourPathInsideJarPattern = Pattern.compile(String.format("%s(.+\\.jar)!/(.+?)[^/]+", "jar://"), 34);
    @NonNls
    private static final String JAR_PROTOCOL = "jar:";
    @NonNls
    private static final String HR = "<HR>";
    @NonNls
    private static final String P = "<P>";
    @NonNls
    private static final String DL = "<DL>";
    @NonNls
    protected static final String H2 = "</H2>";
    @NonNls
    protected static final String HTML_CLOSE = "</HTML>";
    @NonNls
    protected static final String HTML = "<HTML>";
    @NonNls
    private static final String BR = "<BR>";
    @NonNls
    private static final String DT = "<DT>";
    private static final Pattern CHARSET_META_PATTERN = Pattern.compile("<meta[^>]+\\s*charset=\"?([\\w\\-]*)\\s*\">", 2);
    private static final String FIELD_SUMMARY = "<!-- =========== FIELD SUMMARY =========== -->";
    private static final String CLASS_SUMMARY = "<div class=\"summary\">";
    private final HttpConfigurable myHttpConfigurable = HttpConfigurable.getInstance();
    protected final RefConvertor myIMGConvertor = new RefConvertor(ourIMGselector){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String convertReference(String root, String href) {
            String path;
            Matcher matcher;
            if (StringUtil.startsWithChar((CharSequence)href, (char)'#')) {
                return "doc_element://" + root + href;
            }
            String protocol = VirtualFileManager.extractProtocol((String)root);
            if (EXTRACT_IMAGES_FROM_JARS && Comparing.strEqual((String)protocol, (String)"jar") && (matcher = ourPathInsideJarPattern.matcher(root)).matches()) {
                boolean referenceUnpackedImage;
                File unpackedImage;
                block12: {
                    String jarPath = matcher.group(1);
                    String jarName = jarPath;
                    int i = jarName.lastIndexOf(File.separatorChar);
                    if (i >= 0 && i < jarName.length() - 1) {
                        jarName = jarName.substring(i + 1);
                    }
                    jarName = jarName.substring(0, jarName.length() - ".jar".length());
                    String basePath = matcher.group(2);
                    String imgPath = FileUtil.toCanonicalPath((String)(basePath + href));
                    File unpackedImagesRoot = new File(FileUtilRt.getTempDirectory(), AbstractExternalFilter.QUICK_DOC_DIR_NAME);
                    File unpackedJarImagesRoot = new File(unpackedImagesRoot, jarName);
                    unpackedImage = new File(unpackedJarImagesRoot, imgPath);
                    referenceUnpackedImage = true;
                    if (!unpackedImage.isFile()) {
                        referenceUnpackedImage = false;
                        JarFileSystem jarFileSystem = JarFileSystem.getInstance();
                        try {
                            JarFile jarFile = jarFileSystem.getJarFile(jarFileSystem.findFileByPath(jarPath + "!/"));
                            if (jarFile == null) break block12;
                            JarFile.JarEntry entry = jarFile.getEntry(imgPath);
                            if (entry != null) {
                                FileUtilRt.createIfNotExists((File)unpackedImage);
                                FileOutputStream fOut = new FileOutputStream(unpackedImage);
                                try {
                                    FileUtilRt.copy((InputStream)jarFile.getInputStream(entry), (OutputStream)fOut);
                                    referenceUnpackedImage = true;
                                }
                                finally {
                                    fOut.close();
                                }
                            }
                            unpackedImage.deleteOnExit();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                if (referenceUnpackedImage) {
                    return "file://" + unpackedImage.getAbsolutePath();
                }
            }
            if (Comparing.strEqual((String)protocol, (String)"file") && !(path = VirtualFileManager.extractPath((String)root)).startsWith("/")) {
                root = VirtualFileManager.constructUrl((String)"file", (String)("/" + path));
            }
            return ourHTMLFilesuffix.matcher(root).replaceAll("/") + href;
        }
    };

    protected static String doAnnihilate(String path) {
        int len = path.length();
        while (len > (len = (path = ourAnnihilator.matcher(path).replaceAll("/")).length())) {
        }
        return path;
    }

    public String correctRefs(String root, String read) {
        String result = read;
        for (RefConvertor myReferenceConvertor : this.getRefConvertors()) {
            result = myReferenceConvertor.refFilter(root, result);
        }
        return result;
    }

    protected abstract RefConvertor[] getRefConvertors();

    @Nullable
    private static Reader getReaderByUrl(String surl, HttpConfigurable httpConfigurable, ProgressIndicator pi) throws IOException {
        if (surl.startsWith(JAR_PROTOCOL)) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(BrowserUtil.getDocURL((String)surl));
            if (file == null) {
                return null;
            }
            return new StringReader(VfsUtilCore.loadText((VirtualFile)file));
        }
        URL url = BrowserUtil.getURL((String)surl);
        if (url == null) {
            return null;
        }
        URLConnection urlConnection = httpConfigurable.openConnection(url.toString());
        String contentEncoding = AbstractExternalFilter.guessEncoding(url);
        InputStream inputStream = pi != null ? UrlConnectionUtil.getConnectionInputStreamWithException(urlConnection, pi) : urlConnection.getInputStream();
        return contentEncoding != null ? new MyReader(inputStream, contentEncoding) : new MyReader(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String guessEncoding(URL url) {
        String result = null;
        BufferedReader reader = null;
        try {
            URLConnection connection = url.openConnection();
            result = connection.getContentEncoding();
            if (result != null) {
                String string = result;
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String htmlLine = reader.readLine();
            while (htmlLine != null) {
                result = AbstractExternalFilter.parseContentEncoding(htmlLine);
                if (result != null) {
                    break;
                }
                htmlLine = reader.readLine();
            }
        }
        catch (IOException ignored) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
        return result;
    }

    @Nullable
    public String getExternalDocInfo(String surl) throws Exception {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isDispatchThread() || app.isWriteAccessAllowed()) {
            LOG.error("May block indefinitely: shouldn't be called from EDT or under write lock");
            return null;
        }
        if (surl == null) {
            return null;
        }
        if (MyJavadocFetcher.isFree()) {
            MyJavadocFetcher fetcher = new MyJavadocFetcher(surl, new MyDocBuilder(){

                @Override
                public void buildFromStream(String surl, Reader input, StringBuffer result) throws IOException {
                    AbstractExternalFilter.this.doBuildFromStream(surl, input, result);
                }
            });
            Future fetcherFuture = app.executeOnPooledThread((Runnable)fetcher);
            try {
                fetcherFuture.get();
            }
            catch (Exception e) {
                return null;
            }
            Exception exception = fetcher.getException();
            if (exception != null) {
                fetcher.cleanup();
                throw exception;
            }
            String docText = this.correctRefs(ourAnchorsuffix.matcher(surl).replaceAll(""), fetcher.getData());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Filtered JavaDoc: " + docText + "\n");
            }
            return PlatformDocumentationUtil.fixupText(docText);
        }
        return null;
    }

    @Nullable
    public String getExternalDocInfoForElement(String docURL, PsiElement element) throws Exception {
        return this.getExternalDocInfo(docURL);
    }

    protected void doBuildFromStream(String surl, Reader input, StringBuffer data) throws IOException {
        this.doBuildFromStream(surl, input, data, true);
    }

    protected void doBuildFromStream(String surl, Reader input, StringBuffer data, boolean search4Encoding) throws IOException {
        String read;
        BufferedReader buf = new BufferedReader(input);
        Trinity<Pattern, Pattern, Boolean> settings = this.getParseSettings(surl);
        Pattern startSection = (Pattern)settings.first;
        Pattern endSection = (Pattern)settings.second;
        boolean useDt = (Boolean)settings.third;
        String greatestEndSection = "<!-- ========= END OF CLASS DATA ========= -->";
        data.append(HTML);
        data.append("<style type=\"text/css\">  ul.inheritance {\n      margin:0;\n      padding:0;\n  }\n  ul.inheritance li {\n       display:inline;\n       list-style:none;\n  }\n  ul.inheritance li ul.inheritance {\n    margin-left:15px;\n    padding-left:15px;\n    padding-top:1px;\n  }\n</style>");
        String contentEncoding = null;
        do {
            String foundEncoding;
            if ((read = buf.readLine()) == null || !search4Encoding || !read.contains("charset") || (foundEncoding = AbstractExternalFilter.parseContentEncoding(read)) == null) continue;
            contentEncoding = foundEncoding;
        } while (read != null && !startSection.matcher(StringUtil.toUpperCase((String)read)).find());
        if (input instanceof MyReader && contentEncoding != null && !contentEncoding.equalsIgnoreCase("UTF-8") && !contentEncoding.equals(((MyReader)input).getEncoding())) {
            Reader stream;
            try {
                stream = AbstractExternalFilter.getReaderByUrl(surl, this.myHttpConfigurable, new ProgressIndicatorBase());
            }
            catch (ProcessCanceledException e) {
                return;
            }
            data.delete(0, data.length());
            this.doBuildFromStream(surl, new MyReader(((MyReader)stream).getInputStream(), contentEncoding), data, false);
            return;
        }
        if (read == null) {
            data.delete(0, data.length());
            return;
        }
        if (useDt) {
            boolean skip = false;
            do {
                if (StringUtil.toUpperCase((String)read).contains(H2) && !read.toUpperCase().contains("H2")) {
                    data.append(H2);
                    skip = true;
                    continue;
                }
                if (endSection.matcher(read).find() || StringUtil.indexOfIgnoreCase((String)read, (String)greatestEndSection, (int)0) != -1) {
                    data.append(HTML_CLOSE);
                    return;
                }
                if (skip) continue;
                AbstractExternalFilter.appendLine(data, read);
            } while ((read = buf.readLine()) != null && !StringUtil.toUpperCase((String)read).trim().equals(DL) && !StringUtil.containsIgnoreCase((String)read, (String)"<div class=\"description\""));
            data.append(DL);
            StringBuffer classDetails = new StringBuffer();
            while ((read = buf.readLine()) != null && !StringUtil.toUpperCase((String)read).equals(HR) && !StringUtil.toUpperCase((String)read).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data, read, classDetails)) {
                    return;
                }
                AbstractExternalFilter.appendLine(classDetails, read);
            }
            while ((read = buf.readLine()) != null && !StringUtil.toUpperCase((String)read).equals(P) && !StringUtil.toUpperCase((String)read).equals(HR)) {
                if (AbstractExternalFilter.reachTheEnd(data, read, classDetails)) {
                    return;
                }
                AbstractExternalFilter.appendLine(data, read.replaceAll(DT, "<DT><BR>"));
            }
            data.append(classDetails);
            data.append(P);
        } else {
            AbstractExternalFilter.appendLine(data, read);
        }
        while ((read = buf.readLine()) != null && !endSection.matcher(read).find() && StringUtil.indexOfIgnoreCase((String)read, (String)greatestEndSection, (int)0) == -1) {
            if (StringUtil.toUpperCase((String)read).contains(HR) || StringUtil.containsIgnoreCase((String)read, (String)"<ul class=\"blockList\">") || StringUtil.containsIgnoreCase((String)read, (String)"<li class=\"blockList\">")) continue;
            AbstractExternalFilter.appendLine(data, read);
        }
        data.append(HTML_CLOSE);
    }

    @NotNull
    protected Trinity<Pattern, Pattern, Boolean> getParseSettings(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/AbstractExternalFilter", "getParseSettings"));
        }
        Pattern startSection = ourClassDataStartPattern;
        Pattern endSection = ourClassDataEndPattern;
        boolean useDt = true;
        Matcher anchorMatcher = ourAnchorsuffix.matcher(url);
        if (anchorMatcher.find()) {
            useDt = false;
            startSection = Pattern.compile(Pattern.quote("<a name=\"" + anchorMatcher.group(1) + "\""), 2);
            endSection = ourNonClassDataEndPattern;
        }
        Trinity trinity = Trinity.create((Object)startSection, (Object)endSection, (Object)useDt);
        if (trinity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/documentation/AbstractExternalFilter", "getParseSettings"));
        }
        return trinity;
    }

    private static boolean reachTheEnd(StringBuffer data, String read, StringBuffer classDetails) {
        if (StringUtil.indexOfIgnoreCase((String)read, (String)FIELD_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read, (String)CLASS_SUMMARY, (int)0) != -1) {
            data.append(classDetails);
            data.append(HTML_CLOSE);
            return true;
        }
        return false;
    }

    @Nullable
    static String parseContentEncoding(@NotNull String htmlLine) {
        if (htmlLine == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/AbstractExternalFilter", "parseContentEncoding"));
        }
        if (!htmlLine.contains("charset")) {
            return null;
        }
        Matcher matcher = CHARSET_META_PATTERN.matcher(htmlLine);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static void appendLine(StringBuffer buffer, String read) {
        buffer.append(read);
        buffer.append("\n");
    }

    static /* synthetic */ Reader access$200(String x0, HttpConfigurable x1, ProgressIndicator x2) throws IOException {
        return AbstractExternalFilter.getReaderByUrl(x0, x1, x2);
    }

    private static class MyReader
    extends InputStreamReader {
        private InputStream myInputStream;

        public MyReader(InputStream in) {
            super(in);
            this.myInputStream = in;
        }

        public MyReader(InputStream in, String charsetName) throws UnsupportedEncodingException {
            super(in, charsetName);
            this.myInputStream = in;
        }

        public InputStream getInputStream() {
            return this.myInputStream;
        }
    }

    private static class MyJavadocFetcher
    implements Runnable {
        private static boolean ourFree = true;
        private final StringBuffer data = new StringBuffer();
        private final String surl;
        private final MyDocBuilder myBuilder;
        private final Exception[] myExceptions = new Exception[1];
        private final HttpConfigurable myHttpConfigurable;

        public MyJavadocFetcher(String surl, MyDocBuilder builder) {
            this.surl = surl;
            this.myBuilder = builder;
            ourFree = false;
            this.myHttpConfigurable = HttpConfigurable.getInstance();
        }

        public static boolean isFree() {
            return ourFree;
        }

        public String getData() {
            return this.data.toString();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Exception getException() {
            return this.myExceptions[0];
        }

        public void cleanup() {
            this.myExceptions[0] = null;
        }
    }

    private static interface MyDocBuilder {
        public void buildFromStream(String var1, Reader var2, StringBuffer var3) throws IOException;
    }

    protected static abstract class RefConvertor {
        @NotNull
        private final Pattern mySelector;

        public RefConvertor(@NotNull Pattern selector) {
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/documentation/AbstractExternalFilter$RefConvertor", "<init>"));
            }
            this.mySelector = selector;
        }

        protected abstract String convertReference(String var1, String var2);

        public String refFilter(final String root, String read) {
            String toMatch = StringUtil.toUpperCase((String)read);
            StringBuilder ready = new StringBuilder();
            int prev = 0;
            Matcher matcher = this.mySelector.matcher(toMatch);
            while (matcher.find()) {
                String before = read.substring(prev, matcher.start(1) - 1);
                final String href = read.substring(matcher.start(1), matcher.end(1));
                prev = matcher.end(1) + 1;
                ready.append(before);
                ready.append("\"");
                ready.append((String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                    public String compute() {
                        return RefConvertor.this.convertReference(root, href);
                    }
                }));
                ready.append("\"");
            }
            ready.append(read.substring(prev, read.length()));
            return ready.toString();
        }
    }
}

