/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public RemoveUnusedParameterFix(PsiParameter parameter) {
        super((PsiElement)parameter);
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.unused.parameter.text", this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.unused.parameter.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "isAvailable"));
        }
        PsiParameter myParameter = (PsiParameter)startElement;
        return myParameter.isValid() && myParameter.getDeclarationScope() instanceof PsiMethod && myParameter.getManager().isInProject((PsiElement)myParameter);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveUnusedParameterFix", "invoke"));
        }
        PsiParameter myParameter = (PsiParameter)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        RemoveUnusedParameterFix.removeReferences(myParameter);
    }

    private static void removeReferences(PsiParameter parameter) {
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        ChangeSignatureProcessor processor = new ChangeSignatureProcessor(parameter.getProject(), method, false, null, method.getName(), method.getReturnType(), RemoveUnusedParameterFix.getNewParametersInfo(method, parameter));
        processor.run();
    }

    public static ParameterInfoImpl[] getNewParametersInfo(PsiMethod method, PsiParameter parameterToRemove) {
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            if (Comparing.equal((Object)parameter, (Object)parameterToRemove)) continue;
            result.add(new ParameterInfoImpl(i, parameter.getName(), parameter.getType()));
        }
        return result.toArray(new ParameterInfoImpl[result.size()]);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

