/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveRedundantElseAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantElseAction");

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("remove.redundant.else.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.redundant.else.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "isAvailable"));
        }
        if (element instanceof PsiKeyword && element.getParent() instanceof PsiIfStatement && "else".equals(element.getText())) {
            PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
            if (ifStatement.getElseBranch() == null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return false;
            }
            PsiElement block = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiCodeBlock.class);
            if (block != null) {
                while (RemoveRedundantElseAction.cantCompleteNormally(thenBranch, block)) {
                    if ((thenBranch = RemoveRedundantElseAction.getPrevThenBranch((PsiElement)thenBranch)) != null) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Nullable
    private static PsiStatement getPrevThenBranch(@NotNull PsiElement thenBranch) {
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "getPrevThenBranch"));
        }
        PsiElement ifStatement = thenBranch.getParent();
        PsiElement parent = ifStatement.getParent();
        if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() == ifStatement) {
            return ((PsiIfStatement)parent).getThenBranch();
        }
        return null;
    }

    private static boolean cantCompleteNormally(@NotNull PsiStatement thenBranch, PsiElement block) {
        if (thenBranch == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "cantCompleteNormally"));
        }
        try {
            ControlFlow controlFlow = ControlFlowFactory.getInstance(thenBranch.getProject()).getControlFlow(block, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
            int startOffset = controlFlow.getStartOffset((PsiElement)thenBranch);
            int endOffset = controlFlow.getEndOffset((PsiElement)thenBranch);
            return startOffset != -1 && endOffset != -1 && !ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/quickfix/RemoveRedundantElseAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)element.getParent();
        LOG.assertTrue(ifStatement != null && ifStatement.getElseBranch() != null);
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)elseBranch).getCodeBlock().getStatements();
            if (statements.length > 0) {
                ifStatement.getParent().addRangeAfter((PsiElement)statements[0], (PsiElement)statements[statements.length - 1], (PsiElement)ifStatement);
            }
        } else {
            ifStatement.getParent().addAfter((PsiElement)elseBranch, (PsiElement)ifStatement);
        }
        ifStatement.getElseBranch().delete();
    }
}

