/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisOrSuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import org.jetbrains.annotations.NotNull;

public class QualifySuperArgumentFix
extends QualifyThisOrSuperArgumentFix {
    public QualifySuperArgumentFix(@NotNull PsiExpression expression, @NotNull PsiClass psiClass) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/QualifySuperArgumentFix", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/QualifySuperArgumentFix", "<init>"));
        }
        super(expression, psiClass);
    }

    @Override
    protected String getQualifierText() {
        return "super";
    }

    @Override
    protected PsiExpression getQualifier(PsiManager manager) {
        return RefactoringChangeUtil.createSuperExpression(manager, this.myPsiClass);
    }

    public static void registerQuickFixAction(@NotNull PsiSuperExpression expr, HighlightInfo highlightInfo) {
        PsiMethodCallExpression callExpression;
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/QualifySuperArgumentFix", "registerQuickFixAction"));
        }
        LOG.assertTrue(expr.getQualifier() == null);
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class);
        if (containingClass != null && containingClass.isInterface() && (callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethodCallExpression.class)) != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)callExpression.getProject());
            for (PsiClass superClass : containingClass.getSupers()) {
                if (!superClass.isInterface()) continue;
                PsiMethodCallExpression copy = (PsiMethodCallExpression)callExpression.copy();
                PsiExpression superQualifierCopy = copy.getMethodExpression().getQualifierExpression();
                LOG.assertTrue(superQualifierCopy != null);
                superQualifierCopy.delete();
                if (((PsiMethodCallExpression)elementFactory.createExpressionFromText(copy.getText(), (PsiElement)superClass)).resolveMethod() == null) continue;
                QuickFixAction.registerQuickFixAction(highlightInfo, new QualifySuperArgumentFix((PsiExpression)expr, superClass));
            }
        }
    }
}

