/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix");
    @PsiModifier.ModifierConstant
    private final String myModifier;
    private final boolean myShouldHave;
    private final boolean myShowContainingClass;
    private final String myName;
    private final SmartPsiElementPointer<PsiVariable> myVariable;

    public ModifierFix(PsiModifierList modifierList, @PsiModifier.ModifierConstant @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "<init>"));
        }
        super((PsiElement)modifierList);
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
        this.myName = this.format(null, modifierList);
        this.myVariable = null;
    }

    public ModifierFix(@NotNull PsiModifierListOwner owner, @PsiModifier.ModifierConstant @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "<init>"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "<init>"));
        }
        super((PsiElement)owner.getModifierList());
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
        PsiVariable variable = owner instanceof PsiVariable ? (PsiVariable)owner : null;
        this.myName = this.format(variable, owner.getModifierList());
        this.myVariable = variable == null ? null : SmartPointerManager.getInstance((Project)owner.getProject()).createSmartPsiElementPointer((PsiElement)variable);
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "getText"));
        }
        return string;
    }

    private String format(PsiVariable variable, PsiModifierList modifierList) {
        PsiVariable parent;
        String name = null;
        Object object = variable == null ? (modifierList == null ? null : modifierList.getParent()) : (parent = variable);
        if (parent instanceof PsiClass) {
            name = ((PsiClass)parent).getName();
        } else {
            int options = 1 | (this.myShowContainingClass ? 4096 : 0);
            if (parent instanceof PsiMethod) {
                name = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)parent), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)0);
            } else if (parent instanceof PsiVariable) {
                name = PsiFormatUtil.formatVariable((PsiVariable)parent, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            } else if (parent instanceof PsiClassInitializer) {
                PsiClass containingClass = ((PsiClassInitializer)parent).getContainingClass();
                String className = containingClass instanceof PsiAnonymousClass ? QuickFixBundle.message("anonymous.class.presentation", ((PsiAnonymousClass)containingClass).getBaseClassType().getPresentableText()) : (containingClass != null ? containingClass.getName() : "unknown");
                name = QuickFixBundle.message("class.initializer.presentation", className);
            }
        }
        String modifierText = VisibilityUtil.toPresentableText((String)this.myModifier);
        return QuickFixBundle.message(this.myShouldHave ? "add.modifier.fix" : "remove.modifier.fix", name, modifierText);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.modifiers.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "isAvailable"));
        }
        PsiModifierList myModifierList = (PsiModifierList)startElement;
        PsiVariable variable = this.myVariable == null ? null : (PsiVariable)this.myVariable.getElement();
        return myModifierList.isValid() && myModifierList.getManager().isInProject((PsiElement)myModifierList) && myModifierList.hasExplicitModifier(this.myModifier) != this.myShouldHave && (variable == null || variable.isValid());
    }

    private void changeModifierList(PsiModifierList modifierList) {
        try {
            modifierList.setModifierProperty(this.myModifier, this.myShouldHave);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement owner;
        PsiModifierList modifierList;
        PsiVariable variable;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix", "invoke"));
        }
        PsiModifierList myModifierList = (PsiModifierList)startElement;
        PsiVariable psiVariable = variable = this.myVariable == null ? null : (PsiVariable)this.myVariable.getElement();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)myModifierList)) {
            return;
        }
        if (variable != null && !FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)variable)) {
            return;
        }
        final ArrayList modifierLists = new ArrayList();
        final PsiFile containingFile = myModifierList.getContainingFile();
        if (variable != null && variable.isValid()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        variable.normalizeDeclaration();
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
            modifierList = variable.getModifierList();
            assert (modifierList != null);
        } else {
            modifierList = myModifierList;
        }
        if ((owner = modifierList.getParent()) instanceof PsiMethod) {
            PsiModifierList copy = (PsiModifierList)myModifierList.copy();
            this.changeModifierList(copy);
            final int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)copy);
            OverridingMethodsSearch.search((PsiMethod)((PsiMethod)owner), (SearchScope)owner.getResolveScope(), (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

                public boolean execute(@NotNull PsiMethod inheritor) {
                    if (inheritor == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ModifierFix$2", "execute"));
                    }
                    PsiModifierList list = inheritor.getModifierList();
                    if (inheritor.getManager().isInProject((PsiElement)inheritor) && PsiUtil.getAccessLevel((PsiModifierList)list) < accessLevel) {
                        modifierLists.add(list);
                    }
                    return true;
                }
            }));
        }
        if (!modifierLists.isEmpty() && Messages.showYesNoDialog((Project)project, (String)QuickFixBundle.message("change.inheritors.visibility.warning.text", new Object[0]), (String)QuickFixBundle.message("change.inheritors.visibility.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)modifierLists)) {
                        return;
                    }
                    for (PsiModifierList modifierList : modifierLists) {
                        ModifierFix.this.changeModifierList(modifierList);
                    }
                }
            });
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModifierFix.this.changeModifierList(modifierList);
                UndoUtil.markPsiFileForUndo((PsiFile)containingFile);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

