/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class InsertNewFix
implements IntentionAction {
    private final PsiMethodCallExpression myMethodCall;
    private final PsiClass myClass;

    public InsertNewFix(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiClass aClass) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix", "<init>"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix", "<init>"));
        }
        this.myMethodCall = methodCall;
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("insert.new.fix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix", "isAvailable"));
        }
        return this.myMethodCall.isValid() && this.myMethodCall.getManager().isInProject((PsiElement)this.myMethodCall);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/InsertNewFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myMethodCall.getContainingFile())) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myMethodCall.getProject()).getElementFactory();
        PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new X()", null);
        PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
        assert (classReference != null);
        classReference.replace((PsiElement)factory.createClassReferenceElement(this.myClass));
        PsiExpressionList argumentList = newExpression.getArgumentList();
        assert (argumentList != null);
        argumentList.replace((PsiElement)this.myMethodCall.getArgumentList());
        this.myMethodCall.replace((PsiElement)newExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

