/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateAbstractMethodFromUsageFix
extends CreateMethodFromUsageFix {
    public CreateAbstractMethodFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/CreateAbstractMethodFromUsageFix", "<init>"));
        }
        super(methodCall);
    }

    @Override
    protected String getDisplayString(String name) {
        return QuickFixBundle.message("create.abstract.method.from.usage.text", name);
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiReferenceExpression expr = this.getMethodCall().getMethodExpression();
        for (PsiClass each : super.getTargetClasses(element)) {
            if (!PsiUtil.isAbstractClass((PsiClass)each) || each.isInterface() || CreateAbstractMethodFromUsageFix.shouldCreateStaticMember(expr, each)) continue;
            result.add(each);
        }
        ArrayList<PsiClass> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/CreateAbstractMethodFromUsageFix", "getTargetClasses"));
        }
        return arrayList;
    }

    @Override
    protected String getVisibility(PsiClass parentClass, PsiClass targetClass) {
        String result = super.getVisibility(parentClass, targetClass);
        return "public".equals(result) ? result : "protected";
    }

    @Override
    protected boolean shouldBeAbstract(PsiClass targetClass) {
        return true;
    }
}

