/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.DeclarationSearcher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConvertReturnStatementsVisitor
implements ReturnStatementsVisitor {
    private final PsiElementFactory myFactory;
    private final PsiMethod myMethod;
    private final DeclarationSearcher mySearcher;
    private PsiReturnStatement myLatestReturn;
    private final String myDefaultValue;

    public ConvertReturnStatementsVisitor(PsiElementFactory factory, PsiMethod method, PsiType targetType) {
        this.myFactory = factory;
        this.myMethod = method;
        this.mySearcher = new DeclarationSearcher(this.myMethod, targetType);
        this.myDefaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)targetType);
    }

    @Override
    public void visit(final List<PsiReturnStatement> returnStatements) throws IncorrectOperationException {
        PsiReturnStatement statement = (PsiReturnStatement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiReturnStatement>(){

            public PsiReturnStatement compute() {
                return ConvertReturnStatementsVisitor.this.replaceReturnStatements(returnStatements);
            }
        });
        if (statement != null) {
            this.myLatestReturn = statement;
        }
    }

    public PsiReturnStatement getLatestReturn() {
        return this.myLatestReturn;
    }

    private String generateValue(@NotNull PsiElement stopElement) {
        if (stopElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/ConvertReturnStatementsVisitor", "generateValue"));
        }
        PsiVariable variable = this.mySearcher.getDeclaration(stopElement);
        return variable != null ? variable.getName() : this.myDefaultValue;
    }

    public PsiReturnStatement createReturnInLastStatement() throws IncorrectOperationException {
        return (PsiReturnStatement)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiReturnStatement>(){

            public PsiReturnStatement compute() {
                PsiCodeBlock body = ConvertReturnStatementsVisitor.this.myMethod.getBody();
                PsiJavaToken rBrace = body.getRBrace();
                if (rBrace == null) {
                    return null;
                }
                String value = ConvertReturnStatementsVisitor.this.generateValue((PsiElement)rBrace);
                PsiReturnStatement returnStatement = (PsiReturnStatement)ConvertReturnStatementsVisitor.this.myFactory.createStatementFromText("return " + value + ";", (PsiElement)ConvertReturnStatementsVisitor.this.myMethod);
                return (PsiReturnStatement)body.addBefore((PsiElement)returnStatement, (PsiElement)rBrace);
            }
        });
    }

    @Nullable
    public PsiReturnStatement replaceReturnStatements(List<PsiReturnStatement> currentStatements) throws IncorrectOperationException {
        PsiReturnStatement latestReplaced = null;
        for (PsiReturnStatement returnStatement : currentStatements) {
            if (returnStatement.getReturnValue() != null) continue;
            String value = this.generateValue((PsiElement)returnStatement);
            latestReplaced = (PsiReturnStatement)this.myFactory.createStatementFromText("return " + value + ";", returnStatement.getParent());
            latestReplaced = (PsiReturnStatement)returnStatement.replace((PsiElement)latestReplaced);
        }
        return latestReplaced;
    }
}

