/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ManuallySetupExtResourceAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseExtResourceAction
extends BaseIntentionAction {
    BaseExtResourceAction() {
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction", "isAvailable"));
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        String uri = BaseExtResourceAction.findUri(file, offset);
        if (uri == null || !this.isAcceptableUri(uri)) {
            return false;
        }
        this.setText(XmlBundle.message((String)this.getQuickFixKeyId(), (Object[])new Object[0]));
        return true;
    }

    protected boolean isAcceptableUri(String uri) {
        return true;
    }

    protected abstract String getQuickFixKeyId();

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)this.getQuickFixKeyId(), (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String uri = BaseExtResourceAction.findUri(file, offset);
        if (uri == null) {
            return;
        }
        this.doInvoke(file, offset, uri, editor);
    }

    protected abstract void doInvoke(@NotNull PsiFile var1, int var2, @NotNull String var3, Editor var4) throws IncorrectOperationException;

    @Nullable
    public static String findUri(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null || element instanceof PsiWhiteSpace) {
            return null;
        }
        PsiReference currentRef = file.getViewProvider().findReferenceAt(offset, file.getLanguage());
        if (currentRef == null) {
            currentRef = file.getViewProvider().findReferenceAt(offset);
        }
        if (currentRef instanceof URLReference || currentRef instanceof DependentNSReference) {
            return currentRef.getCanonicalText();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof ManuallySetupExtResourceAction;
    }
}

