/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeCastFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final PsiType myType;

    public AddTypeCastFix(@NotNull PsiType type, @NotNull PsiExpression expression) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "<init>"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "<init>"));
        }
        super((PsiElement)expression);
        this.myType = type;
    }

    @NotNull
    public String getText() {
        String string = QuickFixBundle.message("add.typecast.text", this.myType.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.typecast.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "isAvailable"));
        }
        return this.myType.isValid() && startElement.isValid() && startElement.getManager().isInProject(startElement);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInsight/daemon/impl/quickfix/AddTypeCastFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        AddTypeCastFix.addTypeCast(project, (PsiExpression)startElement, this.myType);
    }

    private static void addTypeCast(Project project, PsiExpression originalExpression, PsiType type) {
        PsiExpression typeCast = AddTypeCastFix.createCastExpression(originalExpression, project, type);
        originalExpression.replace((PsiElement)typeCast);
    }

    static PsiExpression createCastExpression(PsiExpression original, Project project, PsiType type) {
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)original);
        if (expression == null) {
            return null;
        }
        if (type.equals(PsiType.NULL)) {
            return null;
        }
        if (type instanceof PsiEllipsisType) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        String text = "(" + type.getCanonicalText(false) + ")value";
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)original.getProject()).getElementFactory();
        PsiTypeCastExpression typeCast = (PsiTypeCastExpression)factory.createExpressionFromText(text, (PsiElement)original);
        typeCast = (PsiTypeCastExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)typeCast);
        if (expression instanceof PsiConditionalExpression) {
            PsiType elseType;
            PsiConditionalExpression conditional = (PsiConditionalExpression)expression.copy();
            PsiExpression thenE = conditional.getThenExpression();
            PsiExpression elseE = conditional.getElseExpression();
            PsiType thenType = thenE == null ? null : thenE.getType();
            PsiType psiType = elseType = elseE == null ? null : elseE.getType();
            if (elseType != null && thenType != null) {
                boolean replaceElse;
                boolean replaceThen = !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)thenType);
                boolean bl = replaceElse = !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)elseType);
                if (replaceThen != replaceElse) {
                    if (replaceThen) {
                        ((PsiExpression)ObjectUtils.assertNotNull((Object)typeCast.getOperand())).replace((PsiElement)thenE);
                        thenE.replace((PsiElement)typeCast);
                    } else {
                        ((PsiExpression)ObjectUtils.assertNotNull((Object)typeCast.getOperand())).replace((PsiElement)elseE);
                        elseE.replace((PsiElement)typeCast);
                    }
                    return conditional;
                }
            }
        }
        ((PsiExpression)ObjectUtils.assertNotNull((Object)typeCast.getOperand())).replace((PsiElement)expression);
        return typeCast;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

